/*
 * Decompiled with CFR 0.152.
 */
package de.xam.resourceloader;

import de.xam.p13n.shared.P13nSearchUtils;
import de.xam.p13n.shared.Personalisation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class ResourceLoaderTool {
    private static final Logger log = LoggerFactory.getLogger(ResourceLoaderTool.class);

    public static InputStream inputStreamFromClassLoader(String resourceFullName) {
        if (resourceFullName.startsWith("/")) {
            throw new IllegalArgumentException("Loading resource with '/' does not work. You tried '" + resourceFullName + "'");
        }
        ClassLoader cl = ResourceLoaderTool.class.getClassLoader();
        InputStream in = cl.getResourceAsStream(resourceFullName);
        if (in != null) {
            log.trace("ClassLoader: Found in CL that loaded this class: '" + resourceFullName + "'");
            return in;
        }
        log.trace("ClassLoader: Not found in CL that loaded this class: '" + resourceFullName + "'");
        cl = Thread.currentThread().getContextClassLoader();
        in = cl.getResourceAsStream(resourceFullName);
        if (in != null) {
            log.trace("ClassLoader: Found in current thread's CL: '" + resourceFullName + "'");
            return in;
        }
        log.trace("ClassLoader: Not found in current thread's CL: '" + resourceFullName + "'");
        return null;
    }

    public static InputStream inputStreamFromDirectory(String baseDir, String resourceName) {
        File resource = ResourceLoaderTool.loadFileResource(baseDir, resourceName);
        if (resource != null) {
            try {
                FileInputStream fis = new FileInputStream(resource);
                return fis;
            }
            catch (FileNotFoundException e) {
                log.trace("Filesystem: Resource not found as " + resource.getAbsolutePath() + " - although we just checked");
            }
        }
        return null;
    }

    public static InputStream inputStreamFromFileSystem(String resourceName, File ... baseDirs) {
        assert (baseDirs != null);
        for (File baseDir : baseDirs) {
            InputStream in = ResourceLoaderTool.inputStreamFromDirectory(baseDir.getAbsolutePath(), resourceName);
            if (in == null) continue;
            return in;
        }
        return null;
    }

    public static File loadFileResource(String baseDir, String resourceName) {
        assert (!resourceName.startsWith("/")) : resourceName;
        File base = new File(baseDir);
        if (base.exists() && base.isDirectory()) {
            File resource = new File(base, resourceName);
            if (resource.exists()) {
                if (log.isTraceEnabled()) {
                    log.trace("Filesystem: Found resource " + resource.getAbsolutePath());
                }
                return resource;
            }
            if (log.isTraceEnabled()) {
                log.trace("Filesystem: Resource not found as " + resource.getAbsolutePath());
            }
        } else {
            log.warn("Filesystem: Skipped searching '" + base.getAbsolutePath() + "' - not found on disk or not a directory");
        }
        return null;
    }

    public static URL loadFromClassLoader(String resourceFullName) {
        if (resourceFullName.startsWith("/")) {
            throw new IllegalArgumentException("Loading resource with '/' does not work. You tried '" + resourceFullName + "'");
        }
        ClassLoader cl = ResourceLoaderTool.class.getClassLoader();
        URL url = cl.getResource(resourceFullName);
        if (url != null) {
            log.trace("ClassLoader: Found in CL that loaded this class: '" + resourceFullName + "'");
            return url;
        }
        log.trace("ClassLoader: Not found in CL that loaded this class: '" + resourceFullName + "'");
        cl = Thread.currentThread().getContextClassLoader();
        url = cl.getResource(resourceFullName);
        if (url != null) {
            log.trace("ClassLoader: Found in current thread's CL: '" + resourceFullName + "'");
            return url;
        }
        log.trace("ClassLoader: Not found in current thread's CL: '" + resourceFullName + "'");
        return null;
    }

    public static URL loadFromFileSystem(String resourceName, File ... baseDirs) {
        assert (baseDirs != null);
        for (File baseDir : baseDirs) {
            URL url = ResourceLoaderTool.loadResourceFromDirectory(baseDir.getAbsolutePath(), resourceName);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public static URL loadResourceFromDirectory(String baseDir, String resourceName) {
        File resource = ResourceLoaderTool.loadFileResource(baseDir, resourceName);
        if (resource != null) {
            try {
                URL url = resource.toURI().toURL();
                return url;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static String resolvePersonalisedResource(Resolver resolver, String packageName, String resourceNamePrefix, String resourceNameExtension, Personalisation p13n) {
        log.debug("Resolving '" + resourceNamePrefix + "' in package '" + packageName + "'");
        for (String fullResourcePath : P13nSearchUtils.getFromGeneralToSpecific((String)packageName, (Personalisation)p13n, (String)resourceNamePrefix, (String)resourceNameExtension)) {
            log.debug("Trying to resolve '" + resourceNamePrefix + "' as '" + fullResourcePath + "'");
            if (!ResourceLoaderTool.resourceExists(resolver, fullResourcePath)) continue;
            log.debug("Resolving '" + resourceNamePrefix + "' as '" + fullResourcePath + "'");
            return fullResourcePath;
        }
        return null;
    }

    public static boolean resourceExists(Resolver resolver, String resourceFullName) {
        return resolver.resolveURL(resourceFullName) != null;
    }

    public static boolean resourceExistsOnClasspath(String resourceFullName) {
        return ResourceLoaderTool.loadFromClassLoader(resourceFullName) != null;
    }

    public static String loadFromClassLoaderToString(String resourceFullName) throws IOException {
        URL url = ResourceLoaderTool.loadFromClassLoader(resourceFullName);
        if (url == null) {
            return null;
        }
        String s = null;
        InputStream in = url.openStream();
        s = IOUtils.toString((InputStream)in);
        in.close();
        return s;
    }

    public static Properties readPropertyResource(String fullResourceName) throws IOException {
        Properties props = new Properties();
        URL url = ResourceLoaderTool.loadFromClassLoader(fullResourceName);
        if (url == null) {
            throw new IllegalArgumentException("Resource '" + fullResourceName + "' not found on classpath");
        }
        InputStream in = url.openStream();
        props.load(in);
        in.close();
        return props;
    }

    public static interface Resolver {
        public URL resolveURL(String var1);
    }

    public static class FileSystemResolver
    implements Resolver {
        private final File[] baseDirs;

        public FileSystemResolver(File baseDir, File ... moreBaseDirs) {
            assert (baseDir != null);
            ArrayList<File> l = new ArrayList<File>();
            l.add(baseDir);
            if (moreBaseDirs != null) {
                for (File f : moreBaseDirs) {
                    l.add(f);
                }
            }
            this.baseDirs = l.toArray(new File[l.size()]);
        }

        @Override
        public URL resolveURL(String resourceFullName) {
            return ResourceLoaderTool.loadFromFileSystem(resourceFullName, this.baseDirs);
        }
    }

    public static class ClasspathResolver
    implements Resolver {
        @Override
        public URL resolveURL(String resourceFullName) {
            return ResourceLoaderTool.loadFromClassLoader(resourceFullName);
        }
    }

    public static class AnyResolver
    extends FileSystemResolver
    implements Resolver {
        public AnyResolver(File baseDir, File ... moreBaseDirs) {
            super(baseDir, moreBaseDirs);
        }

        @Override
        public URL resolveURL(String resourceFullName) {
            URL url = super.resolveURL(resourceFullName);
            if (url == null) {
                url = ResourceLoaderTool.loadFromClassLoader(resourceFullName);
            }
            return url;
        }
    }
}

