/*
 * Decompiled with CFR 0.152.
 */
package de.xam.cmodel.service;

import de.xam.cmodel.service.COptimizedService;
import de.xam.cmodel.service.CServicePattern;
import de.xam.triplerules.IReadonlyTriplePatternSet;
import de.xam.triplerules.ITriplePattern;
import de.xam.triplerules.IVariable;
import org.xydra.base.XId;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class ServiceUtils {
    private static final Logger log = LoggerFactory.getLogger(ServiceUtils.class);

    public static boolean couldTrigger(CServicePattern action, CServicePattern condition) {
        if (action.contentPattern().matches(condition.contentPattern())) {
            return true;
        }
        return ServiceUtils.couldTrigger(action.triplePattern(), condition.triplePattern());
    }

    public static boolean couldTrigger(IReadonlyTriplePatternSet<XId, XId, XId> action, IReadonlyTriplePatternSet<XId, XId, XId> condition) {
        for (ITriplePattern actionPattern : action.patterns()) {
            for (ITriplePattern conditionPattern : condition.patterns()) {
                if (!ServiceUtils.couldTrigger((ITriplePattern<XId, XId, XId>)actionPattern, (ITriplePattern<XId, XId, XId>)conditionPattern)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean couldTrigger(ITriplePattern<XId, XId, XId> action, ITriplePattern<XId, XId, XId> pattern) {
        if (!ServiceUtils.couldTrigger(action.s(), pattern.s())) {
            return false;
        }
        if (!ServiceUtils.couldTrigger(action.p(), pattern.p())) {
            return false;
        }
        return ServiceUtils.couldTrigger(action.o(), pattern.o());
    }

    public static boolean couldTrigger(COptimizedService serviceA, COptimizedService serviceB) {
        return ServiceUtils.couldTrigger(serviceA.action(), serviceB.condition());
    }

    public static <E> boolean couldTrigger(IVariable<E> actionVar, IVariable<E> patternVar) {
        Object expectedPattern = patternVar.getExpected();
        if (expectedPattern == null) {
            return true;
        }
        Object generatedAction = actionVar.getExpected();
        if (generatedAction == null) {
            return true;
        }
        return expectedPattern.equals(generatedAction);
    }
}

