/*
 * Decompiled with CFR 0.152.
 */
package de.xam.cmodel.fact.impl.xydra;

import de.xam.cmodel.content.CBrowserRenderableContent;
import de.xam.cmodel.fact.CEntity;
import de.xam.cmodel.fact.CFact;
import de.xam.cmodel.fact.CFactIndex;
import de.xam.cmodel.fact.CFactSet;
import de.xam.cmodel.fact.CSymbol;
import de.xam.cmodel.fact.CTriple;
import de.xam.cmodel.fact.IChangeData;
import de.xam.cmodel.fact.VocabularyCModel;
import de.xam.cmodel.fact.impl.ReferenceValues;
import de.xam.cmodel.fact.impl.mem.MemoryFactory;
import de.xam.cmodel.fact.impl.xydra.XySymbol;
import de.xam.cmodel.util.XydraUtils;
import java.util.Iterator;
import org.xydra.base.XId;
import org.xydra.base.rmof.XReadableModel;
import org.xydra.base.rmof.XWritableField;
import org.xydra.base.rmof.XWritableModel;
import org.xydra.base.rmof.XWritableObject;
import org.xydra.base.rmof.XWritableRepository;
import org.xydra.base.util.DumpUtilsBase;
import org.xydra.base.value.XIdSetValue;
import org.xydra.base.value.XValue;
import org.xydra.core.XX;
import org.xydra.index.iterator.IFilter;
import org.xydra.index.iterator.ITransformer;
import org.xydra.index.iterator.Iterators;

public class XyFactSet
implements CFactSet {
    private final XWritableModel xmodel;
    private static final XId METADATA = XX.toId((String)"_metadata");
    private static final IFilter<XId> HIDE_INTERNAL_IDS = new IFilter<XId>(){

        public boolean matches(XId entry) {
            return !entry.toString().startsWith("_");
        }
    };
    private transient ReferenceValues<CBrowserRenderableContent> referenceValues = new ReferenceValues();
    private final XWritableRepository xrepo;

    private XWritableObject getMetadataObject() {
        return this.xmodel.getObject(METADATA);
    }

    public XyFactSet(XWritableRepository xrepo, XWritableModel xmodel) {
        this.xrepo = xrepo;
        this.xmodel = xmodel;
    }

    @Override
    public Iterator<CTriple> getTriples() {
        Iterator<XId> sIt = this.getUserObjectIds();
        return Iterators.cascade(sIt, (ITransformer)new ITransformer<XId, Iterator<CTriple>>(){

            public Iterator<CTriple> transform(final XId s) {
                final XWritableObject xo = XyFactSet.this.xmodel.getObject(s);
                if (xo == null) {
                    return Iterators.none();
                }
                Iterator pIt = xo.iterator();
                return Iterators.cascade((Iterator)pIt, (ITransformer)new ITransformer<XId, Iterator<CTriple>>(){

                    public Iterator<CTriple> transform(final XId p) {
                        XWritableField xf = xo.getField(p);
                        if (xf == null) {
                            return Iterators.none();
                        }
                        XValue value = xf.getValue();
                        if (value instanceof XIdSetValue) {
                            assert (value instanceof XIdSetValue);
                            XIdSetValue idSetValue = (XIdSetValue)value;
                            Iterator oIt = idSetValue.iterator();
                            return Iterators.transform((Iterator)oIt, (ITransformer)new ITransformer<XId, CTriple>(){

                                public CTriple transform(XId o) {
                                    return new MemoryFactory().createTriple(s, p, o);
                                }
                            });
                        }
                        return Iterators.none();
                    }
                });
            }
        });
    }

    private Iterator<XId> getUserObjectIds() {
        return Iterators.filter((Iterator)this.xmodel.iterator(), HIDE_INTERNAL_IDS);
    }

    @Override
    public CSymbol getSymbolById(XId id) {
        XWritableObject xo = this.xmodel.getObject(id);
        if (xo == null) {
            return null;
        }
        return new XySymbol(xo);
    }

    public boolean addSymbol(XId id, CBrowserRenderableContent content, boolean isReference) {
        XWritableObject previous = this.xmodel.getObject(id);
        XWritableObject xo = this.xmodel.createObject(id);
        XydraUtils.setProperty(this.xmodel, id, VocabularyCModel.ATTRIBUTE_VALUE_IS_REFERENCE_VALUE, isReference);
        return previous == null || !previous.equals(xo);
    }

    @Override
    public void removeFact(XId id) {
        XWritableObject xo = this.xmodel.getObject(id);
        if (xo == null) {
            return;
        }
        XySymbol symbol = new XySymbol(xo);
        if (symbol.isReference()) {
            this.referenceValues.removeReferenceValue(symbol.getContent());
        }
    }

    @Override
    public String dump() {
        DumpUtilsBase.dump((String)"", (XReadableModel)this.xmodel);
        return "";
    }

    public XId getId() {
        return this.xmodel.getId();
    }

    @Override
    public boolean addTriple(CTriple triple) {
        return this.addTriple(triple.s(), triple.p(), triple.o());
    }

    public boolean addTriple(XId s, XId p, XId o) {
        return XydraUtils.addIdToIdSetValue(this.xmodel.createObject(s), p, o);
    }

    @Override
    public boolean removeTriple(CTriple triple) {
        return this.removeTriple(triple.s(), triple.p(), triple.o());
    }

    public boolean removeTriple(XId s, XId p, XId o) {
        return XydraUtils.removeIdFromIdSetValue(this.xmodel.createObject(s), p, o);
    }

    private void setModelMetadataProperty(XId propertyId, XValue value) {
        XWritableObject xo = this.xmodel.createObject(METADATA);
        XydraUtils.setProperty(xo, propertyId, value);
    }

    @Override
    public CFactIndex getContextModel() {
        return null;
    }

    @Override
    public Iterator<CSymbol> getSymbols() {
        return null;
    }

    @Override
    public Iterator<CEntity> getEntities() {
        return null;
    }

    @Override
    public IChangeData getChangeData() {
        return null;
    }

    @Override
    public String toDebugString() {
        return null;
    }

    @Override
    public void addSymbol(CSymbol symbol) {
    }

    @Override
    public void removeSymbol(CSymbol symbol) {
    }

    @Override
    public void addFact(CFact fact) {
    }

    @Override
    public void removeFact(CFact fact) {
    }

    @Override
    public CFactSet getWritableContextModel() {
        return null;
    }

    @Override
    public void setContextModel(CFactSet context) {
    }

    @Override
    public CFact getFactById(XId factId) {
        return null;
    }

    @Override
    public void removeSymbol(XId symbolId) {
    }

    @Override
    public void addEntity(CEntity entity) {
    }
}

