/*
 * Decompiled with CFR 0.152.
 */
package de.xam.cmodel.content;

import de.xam.cmodel.content.AbstractContentType;
import de.xam.cmodel.content.IContentType;
import org.xydra.base.value.ValueType;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class XydraContentType
extends AbstractContentType
implements IContentType {
    public static final XydraContentType IDLIST = new XydraContentType(ValueType.IdList, false);
    public static final String PREFIX_XYDRA_TYPE_URI = "http://purl.org/net/xydra/datatypes#";
    public static final XydraContentType STRING = new XydraContentType(ValueType.String, true);
    public static final XydraContentType DOUBLE = new XydraContentType(ValueType.Double, true);
    public static final XydraContentType INT = new XydraContentType(ValueType.Integer, true);
    public static final XydraContentType BOOLEAN = new XydraContentType(ValueType.Boolean, true);
    private static final Logger log = LoggerFactory.getLogger(XydraContentType.class);
    private final ValueType xydraType;

    public static IContentType toContentTypeForXydraValueType(ValueType valueType) {
        boolean isStringType = XydraContentType.isXydraStringType(valueType);
        return new XydraContentType(valueType, isStringType);
    }

    public static boolean isXydraStringType(ValueType type) {
        return type == ValueType.Address || type == ValueType.String || type == ValueType.Id || type == ValueType.Long;
    }

    public static boolean isXydraUri(String contentTypeUri) {
        return contentTypeUri.startsWith(PREFIX_XYDRA_TYPE_URI);
    }

    public static XydraContentType parseXydraUri(String contentTypeUri) {
        assert (XydraContentType.isXydraUri(contentTypeUri));
        String typeString = contentTypeUri.substring(PREFIX_XYDRA_TYPE_URI.length());
        ValueType type = XydraContentType.valueOfLowercaseXydraTypename(typeString);
        if (type == null) {
            log.warn("Could not parse ''");
            return null;
        }
        XydraContentType result = new XydraContentType(type, XydraContentType.isXydraStringType(type));
        return result;
    }

    public static String toXydraTypeUri(ValueType type) {
        return XydraContentType.toContentTypeForXydraValueType(type).getUri();
    }

    public static ValueType valueOfLowercaseXydraTypename(String xydraType) {
        for (ValueType v : ValueType.values()) {
            if (!v.toString().toLowerCase().equals(xydraType.toLowerCase())) continue;
            return v;
        }
        return null;
    }

    public XydraContentType(ValueType xydraType, boolean isStringType) {
        super(AbstractContentType.TypeSystem.Xydra, isStringType);
        assert (xydraType != null);
        this.xydraType = xydraType;
    }

    @Override
    public String getAsIanaContentTypeString() {
        return null;
    }

    @Override
    public String getNativeString() {
        return this.xydraType.name();
    }

    @Override
    public String getUri() {
        return PREFIX_XYDRA_TYPE_URI + this.xydraType.name();
    }

    public ValueType getXydraType() {
        return this.xydraType;
    }
}

