/*
 * Decompiled with CFR 0.152.
 */
package de.xam.cmodel.content;

import de.xam.cmodel.content.IContentType;

public abstract class AbstractContentType
implements IContentType {
    protected TypeSystem typeSystem;
    protected boolean isStringType;

    public AbstractContentType(TypeSystem typeSystem, boolean isStringType) {
        this.typeSystem = typeSystem;
        this.isStringType = isStringType;
    }

    public TypeSystem getTypeSystem() {
        return this.typeSystem;
    }

    @Override
    public boolean isStringType() {
        return this.isStringType;
    }

    public String toString() {
        return "AbstractContentType [ typeSystem=" + (Object)((Object)this.getTypeSystem()) + " stringType?" + this.isStringType() + " \n" + "native=" + this.getNativeString() + " \n" + "uri=" + this.getUri() + " \n" + "iana=" + this.getAsIanaContentTypeString() + "]";
    }

    @Override
    public String getCharset() {
        if (this.isStringType()) {
            return "utf-8";
        }
        return null;
    }

    public int hashCode() {
        return this.getNativeString().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof IContentType && ((IContentType)other).getUri().equals(this.getUri());
    }

    public static enum TypeSystem {
        Iana,
        XsdSchema,
        Xydra,
        AnyUri;

    }
}

