/*
 * Decompiled with CFR 0.152.
 */
package org.jukito;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.internal.Errors;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jukito.All;
import org.jukito.GuiceUtils;
import org.jukito.InjectedFrameworkMethod;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

class InjectedStatement
extends Statement {
    private final FrameworkMethod method;
    private final Object test;
    private final Injector injector;

    public InjectedStatement(FrameworkMethod method, Object test, Injector injector) {
        this.method = method;
        this.test = test;
        this.injector = injector;
    }

    public void evaluate() throws Throwable {
        Method javaMethod = this.method.getMethod();
        Errors errors = new Errors((Object)javaMethod);
        List<Key<?>> keys = GuiceUtils.getMethodKeys(javaMethod, errors);
        errors.throwConfigurationExceptionIfErrorsExist();
        Iterator<Object> bindingIter = InjectedFrameworkMethod.class.isAssignableFrom(this.method.getClass()) ? ((InjectedFrameworkMethod)this.method).getBindingsToUseForParameters().iterator() : new ArrayList().iterator();
        ArrayList<Object> injectedParameters = new ArrayList<Object>();
        for (Key<?> key : keys) {
            if (!All.class.equals((Object)key.getAnnotationType())) {
                injectedParameters.add(this.injector.getInstance(key));
                continue;
            }
            if (!bindingIter.hasNext()) {
                throw new AssertionError((Object)"Expected more bindings to fill @All parameters.");
            }
            injectedParameters.add(this.injector.getInstance(((Binding)bindingIter.next()).getKey()));
        }
        this.method.invokeExplosively(this.test, injectedParameters.toArray());
    }
}

