/*
 * Decompiled with CFR 0.152.
 */
package org.jukito;

import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.List;
import org.jukito.InjectedStatement;
import org.junit.internal.runners.model.MultipleFailureException;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectedAfterStatements
extends Statement {
    private final Statement prev;
    private final List<Statement> afters;

    public InjectedAfterStatements(Statement prev, List<FrameworkMethod> afters, Object target, Injector injector) {
        this.prev = prev;
        this.afters = new ArrayList<Statement>(afters.size());
        for (FrameworkMethod method : afters) {
            this.afters.add(new InjectedStatement(method, target, injector));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate() throws Throwable {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        errors.clear();
        try {
            this.prev.evaluate();
        }
        catch (Throwable e) {
            errors.add(e);
        }
        finally {
            for (Statement after : this.afters) {
                try {
                    after.evaluate();
                }
                catch (Throwable e) {
                    errors.add(e);
                }
            }
        }
        if (!errors.isEmpty()) {
            throw new MultipleFailureException(errors);
        }
    }
}

