/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.state;

import de.xam.dwzmodel.io.import_from_x.ImportManager;
import de.xam.dwzmodel.state.FileManager;
import de.xam.dwzmodel.state.StateManager;
import de.xam.kfacet.impl.wiki.WikiFacet;
import de.xam.mybase.model.IoProgressReporter;
import de.xam.mybase.model.api.IMyBase;
import de.xam.mybase.model.api.MyBaseComponent;
import de.xam.p13n.shared.Personalisation;
import java.io.IOException;
import org.xydra.base.Base;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.conf.IConfig;
import org.xydra.env.Env;
import org.xydra.index.impl.DebugReentrantReadWriteLock;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class ModuleManager {
    private static ModuleManager INSTANCE;
    private static final Logger log;
    private FileManager fileManager;
    private IMyBase myBase = null;
    private final DebugReentrantReadWriteLock singleLock = new DebugReentrantReadWriteLock();
    private final StateManager stateManager = new StateManager();
    private WikiFacet wikiFacet;

    public static synchronized ModuleManager get() {
        if (INSTANCE == null) {
            INSTANCE = new ModuleManager();
        }
        return INSTANCE;
    }

    public static XAddress getMainModelAddress() {
        IConfig conf = Env.get().conf();
        XId repoId = (XId)conf.getAs("mybase-repoId", XId.class);
        XId modelId = (XId)conf.getAs("mainModelId", XId.class);
        return Base.toAddress((XId)repoId, (XId)modelId, null, null);
    }

    private ModuleManager() {
    }

    public void boot(IoProgressReporter iop) {
        assert (iop != null);
        iop.reportProgress("Preparing system");
        ModuleManager.runStaticInitializers();
        try {
            this.stateManager.doBoot(iop);
        }
        catch (Throwable e) {
            iop.reportException(e);
            throw new RuntimeException("Error", e);
        }
    }

    private static void runStaticInitializers() {
        ImportManager.init();
    }

    public synchronized FileManager getFiles() {
        if (this.fileManager == null) {
            this.fileManager = new FileManager(this.stateManager);
        }
        return this.fileManager;
    }

    public synchronized IMyBase getMyBase() {
        return this.myBase;
    }

    public WikiFacet getWikiFacet() {
        assert (this.myBase != null);
        if (this.wikiFacet == null) {
            this.wikiFacet = new WikiFacet();
        }
        return this.wikiFacet;
    }

    public DebugReentrantReadWriteLock locks(MyBaseComponent ... components) {
        if (log.isTraceEnabled()) {
            log.trace("Locking " + MyBaseComponent.aggregate((MyBaseComponent[])components));
        }
        return this.singleLock;
    }

    public void setMyBase(IMyBase myBase) {
        assert (myBase != null);
        this.myBase = myBase;
    }

    public void onBeforeUnload() {
        if (this.myBase == null) {
            return;
        }
        try {
            if (this.getFiles().hasActiveFile()) {
                this.getFiles().doClose();
            }
        }
        catch (IOException e) {
            log.warn("Error when closing on servlet unload event", (Throwable)e);
        }
    }

    public void reset() {
        this.onBeforeUnload();
        this.fileManager = null;
        this.myBase = null;
        if (this.singleLock.writeLock().tryLock()) {
            this.singleLock.writeLock().unlock();
        } else {
            log.warn("Lock issues. Write lock still held.");
        }
        if (this.singleLock.readLock().tryLock()) {
            this.singleLock.readLock().unlock();
        } else {
            log.warn("Lock issues. Read lock still held.");
        }
        this.wikiFacet = null;
    }

    public Personalisation getPersonalisation() {
        return Personalisation.EN_US__SAN_FRANCISCO;
    }

    static {
        log = LoggerFactory.getLogger(ModuleManager.class);
    }
}

