/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.state;

import de.xam.cmodel.content.Contents;
import de.xam.cmodel.fact.VocabularyCModel;
import de.xam.dwzmodel.DwzModel;
import de.xam.itemset.IItem;
import de.xam.itemset.VocabularyItemSet;
import de.xam.itemset.impl.xydra.XydraWrapper;
import de.xam.kfacet.impl.wiki.spi.IEntity2Href;
import de.xam.mybase.model.api.IMyBase;
import de.xam.texthtml.text.HumanReadableText;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xydra.base.XId;
import org.xydra.base.change.XEvent;
import org.xydra.base.rmof.XReadableModel;
import org.xydra.base.value.XValue;
import org.xydra.core.model.XChangeLog;
import org.xydra.core.model.delta.ChangeSummaryType;
import org.xydra.core.model.delta.Summarizer;
import org.xydra.core.model.delta.SummaryModel;
import org.xydra.core.model.delta.SummaryObject;
import org.xydra.core.serialize.xml.XmlEncoder;

public class FileVersion {
    public Set<XId> actorIds = new HashSet<XId>();
    private final XChangeLog changeLog;
    private List<XEvent> events;
    public long timestampStart;
    public long timestampEnd;
    private final IMyBase myBase;

    public FileVersion(IMyBase myBase, XChangeLog changeLog, long timestamp, XId actorId) {
        this.myBase = myBase;
        this.changeLog = changeLog;
        this.timestampStart = timestamp;
        this.timestampEnd = timestamp;
        this.actorIds.add(actorId);
    }

    public void mergeIn(FileVersion other) {
        assert (other.changeLog == this.changeLog);
        this.timestampStart = Math.min(this.timestampStart, other.timestampStart);
        this.timestampEnd = Math.max(this.timestampEnd, other.timestampEnd);
        this.events.addAll(other.events);
        this.actorIds.addAll(other.actorIds);
    }

    public String toString() {
        return "rev=" + this.getRev() + ";time=" + this.timestampStart;
    }

    public long getRev() {
        long rev = 0L;
        for (XEvent e : this.events) {
            rev = Math.max(rev, e.getRevisionNumber());
        }
        return rev;
    }

    public long getRevStart() {
        long rev = Long.MAX_VALUE;
        for (XEvent e : this.events) {
            rev = Math.min(rev, e.getRevisionNumber());
        }
        return rev;
    }

    public String getSummary(long minRev) {
        XReadableModel baseSnapshotModel = null;
        Summary summary = FileVersion.summarize(this.myBase, this.changeLog, baseSnapshotModel, this.getRevStart(), this.getRev());
        int numberOfAddRemove = summary.getNumberOfChanges();
        long versionTimespan = this.timestampEnd - this.timestampStart;
        long ONE_MINUTE = 60000L;
        String header_safeHtml = "Version " + this.getRev() + " (" + numberOfAddRemove + " add/removes" + (versionTimespan > 60000L ? " in " + HumanReadableText.niceTimespan((long)versionTimespan) : "") + "<!-- start: " + this.timestampStart + " end: " + this.timestampEnd + " -->" + ") " + summary.toString();
        String details_safeHtml = summary.string_safeHtml;
        boolean canCollapseExpand = numberOfAddRemove > 0;
        boolean collapsed = numberOfAddRemove > 15;
        return "<div class='revision'>\n  <div class='header'>" + header_safeHtml + "&nbsp;<span style='text-align:right;' class='" + (canCollapseExpand ? "glyphicon glyphicon-chevron-" + (collapsed ? "down" : "up") + "" : "") + "'></span></div>\n" + "  <div class='version-details" + (collapsed ? " collapsed" : "") + "'>" + details_safeHtml + "</div>\n" + "</div>";
    }

    private static Summary summarize(IMyBase myBase, XChangeLog changeLog, XReadableModel baseSnapshotModel, long first, long last) {
        Summary summary = new Summary();
        SummaryModel sm = Summarizer.createSummaryModel((XChangeLog)changeLog, (XReadableModel)baseSnapshotModel, (long)first, (long)last);
        IEntity2Href entity2Href = DwzModel.getEntity2Href();
        StringBuilder b_safeHtml = new StringBuilder();
        Iterator oIt = sm.getChildren();
        while (oIt.hasNext()) {
            SummaryObject so;
            Map.Entry entry = (Map.Entry)oIt.next();
            boolean remove = (so = (SummaryObject)entry.getValue()).getChangeSummaryType() == ChangeSummaryType.Removed;
            XValue typeValue = so.getFieldValue(null, VocabularyCModel.ATTRIBUTE_TYPE, remove);
            if (typeValue == null) continue;
            VocabularyCModel.Type type = XydraWrapper.getType((XValue)typeValue);
            switch (type) {
                case Item: {
                    if (remove) {
                        ++summary.itemRemoved;
                    } else {
                        ++summary.itemAdded;
                    }
                    String contentStr = FileVersion.getContent(so, remove);
                    if (contentStr == null) {
                        contentStr = "'" + so.getId() + "'";
                    }
                    b_safeHtml.append("<li class='item " + FileVersion.toCssClass(so.getChangeSummaryType()) + "'>" + "<a href='" + entity2Href.getViewItemUrl(so.getId()) + "'>" + XmlEncoder.encode((String)contentStr) + "</a>" + "</li>\n");
                    break;
                }
                case Property: {
                    if (remove) {
                        ++summary.propRemoved;
                    } else {
                        ++summary.propAdded;
                    }
                    String contentStr = FileVersion.getContent(so, remove);
                    if (contentStr != null) {
                        b_safeHtml.append("<li class='property " + FileVersion.toCssClass(so.getChangeSummaryType()) + "'>");
                        b_safeHtml.append("<span class='property-key'>");
                        XValue p = so.getFieldValue(null, VocabularyItemSet.PROP_STMT_PREDICATE, remove);
                        IItem pItem = myBase.itemSet().getItemById((XId)p);
                        if (pItem != null) {
                            b_safeHtml.append(XmlEncoder.encode((String)pItem.getDisplayString()));
                        }
                        b_safeHtml.append("</span>");
                        b_safeHtml.append("<span class='property-value'>" + XmlEncoder.encode((String)contentStr) + "</span>\n");
                        b_safeHtml.append("</li>\n");
                        break;
                    }
                    b_safeHtml.append("NULL");
                    break;
                }
                case Statement: {
                    if (remove) {
                        ++summary.stmtRemoved;
                    } else {
                        ++summary.stmtAdded;
                    }
                    b_safeHtml.append("<li class='statement " + FileVersion.toCssClass(so.getChangeSummaryType()) + "'>");
                    b_safeHtml.append("<span class='statement-s'>");
                    XValue s = so.getFieldValue(null, VocabularyItemSet.PROP_STMT_SUBJECT, remove);
                    IItem sItem = myBase.itemSet().getItemById((XId)s);
                    if (sItem != null) {
                        b_safeHtml.append(XmlEncoder.encode((String)sItem.getDisplayString()));
                    }
                    b_safeHtml.append("</span>");
                    b_safeHtml.append("<span class='statement-p'>");
                    XValue p = so.getFieldValue(null, VocabularyItemSet.PROP_STMT_PREDICATE, remove);
                    IItem pItem = myBase.itemSet().getItemById((XId)p);
                    if (pItem != null) {
                        b_safeHtml.append(XmlEncoder.encode((String)pItem.getDisplayString()));
                    }
                    b_safeHtml.append("</span>");
                    b_safeHtml.append("<span class='statement-o'>");
                    XValue o = so.getFieldValue(null, VocabularyItemSet.PROP_STMT_OBJECT, remove);
                    IItem oItem = myBase.itemSet().getItemById((XId)o);
                    if (oItem != null) {
                        b_safeHtml.append(XmlEncoder.encode((String)oItem.getDisplayString()));
                    }
                    b_safeHtml.append("</span>");
                    b_safeHtml.append("</li>\n");
                }
            }
        }
        summary.setSummaryString("<ul>" + b_safeHtml.toString() + " </ul> ");
        return summary;
    }

    private static String toCssClass(ChangeSummaryType changeSummaryType) {
        switch (changeSummaryType) {
            case Added: {
                return "add";
            }
            case Removed: {
                return "remove";
            }
        }
        throw new AssertionError();
    }

    private static String getContent(SummaryObject so, boolean remove) {
        XValue contentValue = so.getFieldValue(null, VocabularyCModel.ATTRIBUTE_CONTENT_VALUE, remove);
        String contentStr = Contents.getContentAsString((XValue)contentValue);
        return contentStr;
    }

    public void setEvents(List<XEvent> events) {
        this.events = events;
    }

    public List<XEvent> getEvents() {
        return this.events;
    }

    static class Summary {
        int itemAdded = 0;
        int itemRemoved = 0;
        int propAdded = 0;
        int propRemoved = 0;
        int stmtAdded = 0;
        int stmtRemoved = 0;
        private String string_safeHtml;

        Summary() {
        }

        public int getNumberOfChanges() {
            return this.itemAdded + this.itemRemoved + this.propAdded + this.propRemoved + this.stmtAdded + this.stmtRemoved;
        }

        public void setSummaryString(String string_safeHtml) {
            this.string_safeHtml = string_safeHtml;
        }

        public String toString() {
            StringBuilder summaryText = new StringBuilder();
            if (this.itemAdded > 0 || this.itemRemoved > 0) {
                summaryText.append(" Items: ");
                if (this.itemAdded > 0) {
                    summaryText.append(this.itemAdded);
                    summaryText.append(" added");
                    if (this.itemRemoved > 0) {
                        summaryText.append(", ");
                    }
                }
                if (this.itemRemoved > 0) {
                    summaryText.append(this.itemRemoved);
                    summaryText.append(" removed");
                }
                summaryText.append(".");
            }
            if (this.propAdded > 0 || this.propRemoved > 0) {
                summaryText.append(" Properties: ");
                if (this.propAdded > 0) {
                    summaryText.append(this.propAdded);
                    summaryText.append(" added");
                    if (this.propRemoved > 0) {
                        summaryText.append(", ");
                    }
                }
                if (this.propRemoved > 0) {
                    summaryText.append(this.propRemoved);
                    summaryText.append(" removed");
                }
                summaryText.append(".");
            }
            if (this.stmtAdded > 0 || this.stmtRemoved > 0) {
                summaryText.append(" Statements: ");
                if (this.stmtAdded > 0) {
                    summaryText.append(this.stmtAdded);
                    summaryText.append(" added");
                    if (this.stmtRemoved > 0) {
                        summaryText.append(", ");
                    }
                }
                if (this.stmtRemoved > 0) {
                    summaryText.append(this.stmtRemoved);
                    summaryText.append(" removed");
                }
                summaryText.append(".");
            }
            return summaryText.toString();
        }
    }
}

