/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.state;

import com.calpano.kgif.io.common.ITempFileProvider;
import de.xam.dwzmodel.io.DwzFileFormats;
import de.xam.dwzmodel.io.persistence.NextFiles;
import de.xam.dwzmodel.state.LockHolder;
import de.xam.dwzmodel.state.ProjectProperties;
import de.xam.files.FileTools;
import de.xam.mybase.model.IoProgressReporter;
import de.xam.texthtml.text.EncTool;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.utils.HostUtils;

public class DirStore
implements ITempFileProvider {
    private static final String FILENAME_EXTENSION_SNAPSHOT = ".snapshot." + DwzFileFormats.CACHE.getDefaultExtension();
    static final String FILENAME_PREFIX_REV = "rev-";
    private static final Logger log = LoggerFactory.getLogger(DirStore.class);
    private final String dirName;
    private final File publicRootDir;
    private final File shadowRootDir;
    private final boolean writeMode;

    private static void explainLockProblem(DirStore dirStore, IoProgressReporter iop) {
        Map<String, String> lockProperties = dirStore.getLockProperties();
        if (lockProperties.isEmpty()) {
            iop.reportProgress("Knowledge file is in use. It was created by DenkWerkZeug version < 1.5.4");
            return;
        }
        String ownerHost = lockProperties.get("id-hostName");
        String ownerName = lockProperties.get("id-userName");
        String thisHost = HostUtils.getLocalHostname();
        boolean sameHost = ownerHost != null && ownerHost.equals(thisHost);
        iop.reportProgress("Knowledge file '" + dirStore.getFileName() + "' is in use by another app (" + (sameHost ? "on this machine" : "on a remote machine named '" + ownerHost + " by user '" + ownerName + "', while we are on '" + thisHost + "'. Delete the file '" + dirStore.getLockFile().getAbsolutePath() + "' if you are sure you changed this file :-)") + ")");
    }

    private File getLockFile() {
        return LockHolder.getDirLockFile(this.getPublicLocalDir());
    }

    public static long getSnapshotRev(File snapshotFile) {
        String name = snapshotFile.getName();
        assert (name.startsWith(FILENAME_PREFIX_REV) && name.endsWith(FILENAME_EXTENSION_SNAPSHOT));
        String s = name.substring(FILENAME_PREFIX_REV.length());
        s = s.substring(0, s.length() - FILENAME_EXTENSION_SNAPSHOT.length());
        long rev = Long.parseLong(s);
        return rev;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DirStore open(File publicDir, File shadowDir, String localName, IoProgressReporter iop, boolean writeMode, boolean mayCreate, boolean checkIsNew) throws IOException {
        boolean haveValidLock;
        DirStore dirStore = new DirStore(publicDir, shadowDir, localName, writeMode);
        assert (!mayCreate || writeMode);
        if (dirStore.exists()) {
            if (checkIsNew) {
                throw new IllegalStateException("Cannot create already existing localName '" + localName + "'");
            }
        } else {
            if (!writeMode) return null;
            if (mayCreate) {
                dirStore.createPublicKnowledgeFileDir();
                assert (dirStore.exists());
            } else {
                log.info("Directory not present and should not create");
                return null;
            }
        }
        if (!writeMode || (haveValidLock = dirStore.lock())) return dirStore;
        log.info("Could not lock");
        DirStore.explainLockProblem(dirStore, iop);
        return null;
    }

    private static File toCacheFile(File shadowDir, String localName, String cacheName) {
        File f = new File(shadowDir, localName + "/" + cacheName + "." + DwzFileFormats.CACHE.getDefaultExtension());
        return f;
    }

    private DirStore(File publicRootDir, File shadowRootDir, String fileName, boolean writeMode) throws IOException {
        assert (publicRootDir.exists()) : "Dir not found: " + publicRootDir.getAbsolutePath();
        assert (publicRootDir.isDirectory());
        assert (shadowRootDir.exists());
        assert (shadowRootDir.isDirectory());
        this.publicRootDir = publicRootDir;
        this.shadowRootDir = shadowRootDir;
        this.dirName = fileName;
        this.writeMode = writeMode;
    }

    public void close() {
        this.unlock();
    }

    private void createPublicKnowledgeFileDir() {
        this.ensureWriteMode();
        this.getPublicLocalDir().mkdirs();
    }

    public void deleteHistoryFiles() throws IOException {
        this.ensureWriteMode();
        this.getAutosavedFile().delete();
        this.getHistoryFile().delete();
        File[] files = this.getSnapshotFiles();
        if (files != null) {
            for (File f : files) {
                f.delete();
            }
        }
    }

    public void deleteNextFiles() {
        this.ensureWriteMode();
        NextFiles.deleteNextFiles(this.getPublicLocalDir());
        NextFiles.deleteNextFiles(this.getShadowLocalDir());
    }

    private void ensureWriteMode() {
        if (!this.writeMode) {
            throw new IllegalStateException("dirStore is in read-only mode");
        }
    }

    public boolean exists() {
        return this.getPublicLocalDir().exists();
    }

    public File getAutosavedFile() {
        return this.getPublicFile(DwzFileFormats.AUTOSAVED_CHANGES.getDefaultFileName());
    }

    public String getFileName() {
        return this.dirName;
    }

    public File getHistoryFile() {
        return this.getPublicFile(DwzFileFormats.HISTORY.getDefaultFileName());
    }

    public Map<String, String> getLockProperties() {
        LockHolder lh = LockHolder.getOrCreateLockHolder(this.getPublicLocalDir(), true);
        if (lh == null) {
            return null;
        }
        return lh.getLockProperties();
    }

    public String getMetaString() {
        return "meta";
    }

    private File getProjectPropertiesFile() {
        return this.getPublicFile(DwzFileFormats.PROJECT_PROPERTIES.getDefaultFileName());
    }

    public File getPublicFile(String localFileName) {
        return new File(this.getPublicLocalDir(), localFileName);
    }

    public File getPublicLocalDir() {
        return new File(this.publicRootDir, this.getDirNameForFileSystem());
    }

    private String getDirNameForFileSystem() {
        String enc = EncTool.escapeFilename((String)this.dirName);
        return enc;
    }

    public File getShadowFile(String localFileName) {
        return new File(this.getShadowLocalDir(), localFileName);
    }

    public File getShadowLocalDir() {
        return new File(this.shadowRootDir, this.getDirNameForFileSystem());
    }

    public long getSize() {
        long size = FileTools.spaceUsedInDir((File)this.getPublicLocalDir());
        return size;
    }

    public File getSnapshotFile(long revisionNumber) {
        return this.getShadowFile(FILENAME_PREFIX_REV + revisionNumber + FILENAME_EXTENSION_SNAPSHOT);
    }

    public File[] getSnapshotFiles() {
        return this.getShadowLocalDir().listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                String name = f.getName();
                return f.isFile() && name.endsWith(FILENAME_EXTENSION_SNAPSHOT);
            }
        });
    }

    @Deprecated
    File getTimestampsFile() {
        return new File(this.shadowRootDir, this.getDirNameForFileSystem() + "/revisions-and-time.properties");
    }

    public boolean isLockedOnThisOS() {
        LockHolder lh = LockHolder.getOrCreateLockHolder(this.getPublicLocalDir(), false);
        return lh != null && lh.isLocked();
    }

    public boolean isWriteMode() {
        return this.writeMode;
    }

    private boolean lock() {
        this.ensureWriteMode();
        LockHolder lh = LockHolder.getOrCreateLockHolder(this.getPublicLocalDir(), true);
        if (lh.isLocked()) {
            return true;
        }
        return lh.lock();
    }

    private InputStream openCacheFileInputStream(String localName, String cacheName) {
        FileInputStream fis;
        File f = DirStore.toCacheFile(this.getShadowLocalDir(), localName, cacheName);
        if (!f.exists()) {
            return null;
        }
        try {
            fis = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File got deleted milliseconds ago.", e);
        }
        return fis;
    }

    private OutputStream openCacheFileOutputStream(String localName, String cacheName) {
        FileOutputStream fos;
        this.ensureWriteMode();
        File f = DirStore.toCacheFile(this.getShadowLocalDir(), localName, cacheName);
        f.getParentFile().mkdirs();
        try {
            fos = new FileOutputStream(f);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Could not create cache file", e);
        }
        return fos;
    }

    public InputStream openInputStream(String cacheName) {
        return this.openCacheFileInputStream(this.getDirNameForFileSystem(), cacheName);
    }

    public OutputStream openOutputStream(String cacheName) {
        this.ensureWriteMode();
        return this.openCacheFileOutputStream(this.getDirNameForFileSystem(), cacheName);
    }

    public ProjectProperties readProjectProperties() throws IOException {
        File f = this.getProjectPropertiesFile();
        return ProjectProperties.readFrom(f);
    }

    public String toString() {
        return "DirStore on '" + this.getDirNameForFileSystem() + "'";
    }

    private void unlock() {
        this.ensureWriteMode();
        LockHolder lh = LockHolder.getOrCreateLockHolder(this.getPublicLocalDir(), false);
        if (lh != null) {
            lh.unlock();
        }
    }

    public void writeProjectProperties(ProjectProperties projectProperties) throws IOException {
        this.ensureWriteMode();
        File f = this.getProjectPropertiesFile();
        projectProperties.writeTo(f);
    }

    public File createTempFile(String localName) {
        File tempFile = this.getShadowFile(localName);
        return tempFile;
    }
}

