/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.io.persistence;

import de.xam.dwzmodel.io.util.ReportingImportStream;
import de.xam.itemset.ConfParamsItemSet;
import de.xam.mybase.model.IoProgressReporter;
import de.xam.texthtml.text.HumanReadableText;
import de.xam.texthtml.text.Unicodes;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.minio.MiniReader;
import org.xydra.base.minio.MiniStreamReader;
import org.xydra.base.minio.MiniStreamWriter;
import org.xydra.base.minio.MiniWriter;
import org.xydra.base.rmof.XReadableModel;
import org.xydra.core.model.XChangeLogState;
import org.xydra.core.model.XModel;
import org.xydra.core.model.impl.memory.sync.ISyncLog;
import org.xydra.core.model.impl.memory.sync.MemorySyncLog;
import org.xydra.core.model.impl.memory.sync.XSyncLogState;
import org.xydra.core.serialize.SerializedModel;
import org.xydra.core.serialize.XydraElement;
import org.xydra.core.serialize.XydraOut;
import org.xydra.core.serialize.json.JsonOut;
import org.xydra.core.serialize.json.JsonParser;
import org.xydra.core.serialize.xml.XmlOut;
import org.xydra.core.serialize.xml.XmlParser;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class XydraIO {
    private static final Logger log = LoggerFactory.getLogger(XydraIO.class);

    public static boolean readSyncLogStateFromXmlXydra(File file, XSyncLogState target) throws IOException {
        if (!file.exists()) {
            return false;
        }
        log.info("Parsing file with " + HumanReadableText.fileSize((long)file.length()));
        FileInputStream fis = new FileInputStream(file);
        InputStreamReader ows = new InputStreamReader((InputStream)fis, Unicodes.UTF8);
        MiniStreamReader miniReader = new MiniStreamReader((Reader)ows);
        try {
            XydraIO.readSyncLogStateFromXmlXydraViaMiniReader((MiniReader)miniReader, target);
        }
        catch (Throwable e) {
            log.warn("Could not read " + file.getAbsolutePath(), e);
            throw e;
        }
        miniReader.close();
        ows.close();
        fis.close();
        return true;
    }

    public static void readSyncLogStateFromXmlXydraViaMiniReader(MiniReader miniReader, XSyncLogState target) {
        XmlParser parser = new XmlParser();
        XydraElement xe = parser.parse(miniReader);
        SerializedModel.loadSyncLogState((XydraElement)xe, (XSyncLogState)target);
    }

    public static void writeSyncLogStateToJsonXydra(XSyncLogState SyncLogState, File f) throws IOException {
        f.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(f);
        XydraIO.writeSyncLogStateToJsonXydra(SyncLogState, fos);
        fos.close();
    }

    public static void writeSyncLogStateToJsonXydra(XSyncLogState syncLogState, OutputStream out) {
        MiniStreamWriter miniWriter = new MiniStreamWriter(out);
        JsonOut JsonOut2 = new JsonOut((MiniWriter)miniWriter);
        JsonOut2.enableWhitespace(true, true);
        SerializedModel.serialize((XChangeLogState)syncLogState, (XydraOut)JsonOut2);
        miniWriter.flush();
        miniWriter.close();
    }

    public static void writeSyncLogStateToXmlXydra(XSyncLogState syncLogState, File f) throws IOException {
        f.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(f);
        XydraIO.writeSyncLogStateToXmlXydra(syncLogState, fos);
        fos.close();
    }

    public static void writeSyncLogStateToXmlXydra(XSyncLogState syncLogState, OutputStream out) {
        MiniStreamWriter miniWriter = new MiniStreamWriter(out);
        XmlOut xmlOut = new XmlOut((MiniWriter)miniWriter);
        xmlOut.enableWhitespace(true, true);
        MemorySyncLog syncLog = new MemorySyncLog(syncLogState);
        SerializedModel.serialize((ISyncLog)syncLog, (XydraOut)xmlOut, (XAddress)syncLogState.getBaseAddress());
        miniWriter.flush();
        miniWriter.close();
    }

    public static void writeXModelToJsonXydra(XModel xmodel, File f) throws IOException {
        f.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(f);
        XydraIO.writeXModelToJsonXydra(xmodel, fos);
        fos.close();
    }

    public static void writeXModelToJsonXydra(XModel model, OutputStream out) {
        MiniStreamWriter miniWriter = new MiniStreamWriter(out);
        XydraIO.writeXModelToJsonXydraViaMiniWriter(model, (MiniWriter)miniWriter);
        miniWriter.close();
    }

    public static void writeXModelToJsonXydraViaMiniWriter(XModel xmodel, MiniWriter miniWriter) {
        JsonOut JsonOut2 = new JsonOut(miniWriter);
        JsonOut2.enableWhitespace(true, true);
        SerializedModel.serialize((XReadableModel)xmodel, (XydraOut)JsonOut2);
        miniWriter.flush();
    }

    public static void writeXModelToXmlXydra(XModel xmodel, File f) throws IOException {
        f.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(f);
        XydraIO.writeXModelToXmlXydra(xmodel, fos);
        fos.close();
    }

    public static void writeXModelToXmlXydra(XModel model, OutputStream out) {
        MiniStreamWriter miniWriter = new MiniStreamWriter(out);
        XydraIO.writeXModelToXmlXydraViaMiniWriter(model, (MiniWriter)miniWriter);
        miniWriter.close();
    }

    public static void writeXModelToXmlXydraViaMiniWriter(XModel xmodel, MiniWriter miniWriter) {
        XmlOut xmlOut = new XmlOut(miniWriter);
        xmlOut.enableWhitespace(true, true);
        SerializedModel.serialize((XReadableModel)xmodel, (XydraOut)xmlOut);
        miniWriter.flush();
    }

    public static XModel readXModelFromJsonXydra(File file, IoProgressReporter iop) throws IOException {
        if (!file.exists()) {
            return null;
        }
        log.info("Parsing file with " + HumanReadableText.fileSize((long)file.length()));
        FileInputStream fis = new FileInputStream(file);
        ReportingImportStream ris = new ReportingImportStream(iop, fis);
        InputStreamReader ows = new InputStreamReader((InputStream)ris, Unicodes.UTF8);
        MiniStreamReader miniReader = new MiniStreamReader((Reader)ows);
        JsonParser parser = new JsonParser();
        XydraElement xe = parser.parse((MiniReader)miniReader);
        XId actorId = ConfParamsItemSet._ACTOR_LOCALHOST;
        String passwordHash = "localhost";
        XModel xmodel = SerializedModel.toModel((XId)actorId, (String)"localhost", (XydraElement)xe);
        miniReader.close();
        ows.close();
        ris.close();
        fis.close();
        return xmodel;
    }

    public static XModel readXModelFromXmlXydra(Reader reader, IoProgressReporter iop) throws IOException {
        MiniStreamReader miniReader = new MiniStreamReader(reader);
        XmlParser parser = new XmlParser();
        XydraElement xe = parser.parse((MiniReader)miniReader);
        XId actorId = ConfParamsItemSet._ACTOR_LOCALHOST;
        String passwordHash = "localhost";
        XModel xmodel = SerializedModel.toModel((XId)actorId, (String)"localhost", (XydraElement)xe);
        miniReader.close();
        return xmodel;
    }

    public static XModel readXModelFromXmlXydra(File file, IoProgressReporter iop) throws IOException {
        if (!file.exists()) {
            return null;
        }
        log.info("Parsing file with " + HumanReadableText.fileSize((long)file.length()));
        FileInputStream fis = new FileInputStream(file);
        ReportingImportStream ris = new ReportingImportStream(iop, fis);
        InputStreamReader ows = new InputStreamReader((InputStream)ris, Unicodes.UTF8);
        XModel xmodel = XydraIO.readXModelFromXmlXydra(ows, iop);
        ows.close();
        ris.close();
        fis.close();
        return xmodel;
    }
}

