/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.io.import_from_x;

import com.calpano.kgif.io.FileFormat;
import com.calpano.kgif.io.FileFormats;
import com.calpano.kgif.io.IFileFormat;
import com.calpano.kgif.io.KgifMeta;
import com.calpano.kgif.io.common.IKgifStreamImporter;
import com.calpano.kgif.io.common.IRepeatableStreamSource;
import com.calpano.kgif.io.common.IStreamSink;
import com.calpano.kgif.io.common.IStreamSource;
import com.calpano.kgif.io.common.IStreamTransformer;
import com.calpano.kgif.io.common.ITempFileProvider;
import com.calpano.kgif.io.common.KnownKgifImporter;
import com.calpano.kgif.io.common.impl.AbstractImporterToEntityHandler;
import com.calpano.kgif.io.common.impl.FileStreamSink;
import com.calpano.kgif.io.common.impl.FileStreamSource;
import com.calpano.kgif.io.common.impl.Kgif1_1_0_Importer;
import com.calpano.kgif.io.common.impl.NoUnicodeReplacementCharFilterReader;
import com.calpano.kgif.io.common.util.KgifNIO;
import com.calpano.kgif.io.common.util.StreamSources;
import com.google.monitoring.runtime.instrumentation.common.com.google.common.collect.Sets;
import de.xam.dwzmodel.io.DwzFileFormats;
import de.xam.dwzmodel.io.ImportResult;
import de.xam.dwzmodel.io.import_before_kgif.DataFilesImporter;
import de.xam.dwzmodel.io.import_before_kgif.ItemsXmlImporter;
import de.xam.dwzmodel.io.import_before_kgif.XStreamImporter;
import de.xam.dwzmodel.io.import_kgif_110.Kgif1_1_0Manager;
import de.xam.dwzmodel.io.import_kgif_old.Kgif1_0_0Importer;
import de.xam.dwzmodel.io.import_kgif_old.Kgif1_0_1Importer;
import de.xam.dwzmodel.io.util.KgifManager;
import de.xam.dwzmodel.state.DirStore;
import de.xam.files.FileTools;
import de.xam.files.FilenameUtils;
import de.xam.mybase.model.IoProgressReporter;
import de.xam.mybase.model.api.IMyBase;
import de.xam.texthtml.text.Unicodes;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xydra.index.IPair;
import org.xydra.index.impl.ScoringMap;
import org.xydra.index.query.Pair;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class ImportManager {
    private static final Logger log = LoggerFactory.getLogger(ImportManager.class);
    private static final Set<String> DWZ_FILE_EXT = new HashSet<String>();
    private static final FileFilter FILTER_COULD_BE_IMPORTABLE;
    private static final double Q_EXTENSION_MATCHES = 0.2;
    private static final double Q_NAME_MATCHES = 0.3;
    private static final double Q_CONTENTTYPE_MATCHES = 0.4;
    private static final double Q_KGIF_METADATA_VERSION_MATCHES = 1.0;

    private static void checkAndTuneEncoding(IStreamSource source, IoProgressReporter iop) throws IOException {
        int byteBufferSize = 0x100000;
        source.setMinBufferSize(0x100000);
        InputStream in = source.getInputStream();
        in.skip(0x100000L);
        if (ImportManager.containsUnicodeReplacementCharactersInBufferedPart(source)) {
            iop.reportProgress("File seems not to be UTF-8 encoded. Found a 'Unicode Replacement Character' (u+FFFD)");
            HashSet blacklist = Sets.newHashSet((Object[])new Charset[]{Unicodes.UTF8});
            Charset encoding = StreamSources.guessEncoding((IStreamSource)source, (Set)blacklist);
            if (encoding == null) {
                iop.reportProgress("Could not auto-detect the correct encoding of '" + source.getSourceName() + "'. Using default UTF-8.");
            } else {
                iop.reportProgress("Detected encoding '" + encoding + "'");
                source.setEncoding(encoding);
                if (ImportManager.containsUnicodeReplacementCharactersInBufferedPart(source)) {
                    iop.reportProgress("Hmm, found still 'Unicode Replacement Character', going back to UTF-8.");
                    source.setEncoding(Unicodes.UTF8);
                } else {
                    iop.reportProgress("Yep, '" + encoding + "' looks correct.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean containsUnicodeReplacementCharactersInBufferedPart(IStreamSource source) throws IOException {
        if (source.getByteBufferSize() < 4) {
            throw new IllegalStateException("setMinBufferSize() first with a buffer of minimum 4 bytes, better much more");
        }
        boolean optionBefore = source.isOption("READER__DISALLOW_UNICODE_REPLACEMENT_CHARACTER");
        source.setOption("READER__DISALLOW_UNICODE_REPLACEMENT_CHARACTER", (Object)true);
        try {
            boolean bl;
            Throwable throwable;
            Reader reader;
            block19: {
                block20: {
                    reader = source.getReader();
                    throwable = null;
                    char[] cbuf = new char[source.getByteBufferSize() / 4];
                    int read = 0;
                    while (read >= 0) {
                        read = reader.read(cbuf);
                    }
                    bl = false;
                    if (reader == null) break block19;
                    if (throwable == null) break block20;
                    try {
                        reader.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    break block19;
                }
                reader.close();
            }
            return bl;
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (reader != null) {
                            if (throwable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                reader.close();
                            }
                        }
                        throw throwable3;
                    }
                }
                catch (NoUnicodeReplacementCharFilterReader.FoundUnicodeReplacementCharException e) {
                    boolean bl2 = true;
                    return bl2;
                }
            }
        }
        finally {
            source.setOption("READER__DISALLOW_UNICODE_REPLACEMENT_CHARACTER", (Object)optionBefore);
        }
    }

    private static ImportResult doImportFromKgif1_1_0(DirStore dirStore, IRepeatableStreamSource repeatableSource, IMyBase myBase, IoProgressReporter iop) {
        IRepeatableStreamSource validSource;
        boolean valid;
        log.info("Importing " + repeatableSource.getSourceName() + " as KGIF 1.1.0");
        ImportResult importResult = new ImportResult();
        try {
            valid = KgifNIO.validate((IStreamSource)repeatableSource, (IoProgressReporter)iop, (boolean)false);
        }
        catch (IOException e) {
            iop.reportProgress("Problems while reading " + repeatableSource.getSourceName());
            iop.reportException((Throwable)e);
            return importResult;
        }
        if (valid) {
            iop.reportProgress("Valid KGIF");
            validSource = repeatableSource;
        } else {
            iop.reportProgressFailed("KGIF is not valid. Auto-repairing...");
            try {
                IStreamTransformer repair = Kgif1_1_0Manager.createRepairTransformer();
                File tempFile = ImportManager.getKgif1_1_0TempFile(dirStore, (IStreamSource)repeatableSource, "autorepair");
                FileStreamSink sink = new FileStreamSink(tempFile);
                StreamSources.transformIfUpdated((IStreamSource)repeatableSource, (IStreamTransformer)repair, (IStreamSink)sink, (IoProgressReporter)iop);
                iop.reportProgressSuccess("Auto-repair worked.");
                validSource = new FileStreamSource(tempFile);
                try {
                    valid = KgifNIO.validate((IStreamSource)validSource, (IoProgressReporter)iop, (boolean)true);
                }
                catch (IOException e) {
                    iop.reportException((Throwable)e);
                    return importResult;
                }
            }
            catch (IOException e) {
                iop.reportException((Throwable)e);
                return importResult;
            }
        }
        return ImportManager.doImportValidKgif1_1_0(dirStore, (IStreamSource)validSource, myBase, iop);
    }

    private static ImportResult doImportValidKgif1_1_0(DirStore dirStore, IStreamSource source, IMyBase myBase, IoProgressReporter iop) {
        ImportResult importResult = new ImportResult();
        File tempFile = ImportManager.getKgif1_1_0TempFile(dirStore, source, "sorted");
        FileStreamSink tempSink = new FileStreamSink(tempFile);
        try {
            Kgif1_1_0Manager.sortByChangeDate(source, (IStreamSink)tempSink, iop);
            FileStreamSource kgifSource = new FileStreamSource(tempFile);
            return Kgif1_1_0Manager.readValidSortedKgif1_1_0fromSourceIntoMyBase((IStreamSource)kgifSource, myBase, iop);
        }
        catch (IOException e) {
            iop.reportException((Throwable)e);
            return importResult;
        }
    }

    public static File createImportTempFile(IStreamSource source, DirStore dirStore) {
        return ImportManager.getKgif1_1_0TempFile(dirStore, source, "import");
    }

    private static File getKgif1_1_0TempFile(DirStore dirStore, IStreamSource source, String classifier) {
        String name = source.getSourceName();
        String ext = FilenameUtils.getExtension((String)name);
        ext = ext == null ? ".temp" : ".temp." + ext;
        int i = name.lastIndexOf(45);
        if (i > 0) {
            name = name.substring(0, i);
        }
        File tempFile = dirStore.createTempFile(name + "-" + classifier + ext);
        return tempFile;
    }

    public static void init() {
        KnownKgifImporter.importer.add(new DataFilesImporter());
        KnownKgifImporter.importer.add(new ItemsXmlImporter());
        KnownKgifImporter.importer.add(new XStreamImporter());
    }

    private static void scoreImportersByNameAndContentType(ScoringMap<IKgifStreamImporter> map, String sourceName, String contentType, IoProgressReporter iop) {
        DwzFileFormats.init();
        if (sourceName != null || contentType != null) {
            for (IKgifStreamImporter importer : KnownKgifImporter.getKnownImporter()) {
                FileFormat importerFileFormat = importer.getFileFormat();
                if (sourceName != null) {
                    if (FileFormats.matchesDefaultFileName((FileFormat)importerFileFormat, (String)sourceName)) {
                        map.index((Object)importer, (Object)0.3);
                        continue;
                    }
                    if (FileFormats.matchesExtension((IFileFormat)importerFileFormat, (String)sourceName)) {
                        map.index((Object)importer, (Object)0.2);
                        continue;
                    }
                }
                if (contentType == null || importerFileFormat.getContentType() == null || !importerFileFormat.getContentType().equals(contentType)) continue;
                map.index((Object)importer, (Object)0.4);
            }
            if (sourceName != null && sourceName.equals("items.xml")) {
                IKgifStreamImporter itemsXmlImporter = KnownKgifImporter.getKgifImporter((IFileFormat)DwzFileFormats.ITEMS_XML);
                assert (itemsXmlImporter != null);
                map.index((Object)itemsXmlImporter, (Object)0.3);
            }
        }
    }

    private static void scoreImportersByContent(ScoringMap<IKgifStreamImporter> map, IRepeatableStreamSource repeatableSource, IoProgressReporter iop) {
        Object kgifImporter;
        repeatableSource.setMinBufferSize(16384);
        KgifMeta kgifMeta = KgifManager.detectMetaFromDoctype((IStreamSource)repeatableSource);
        if (kgifMeta != null) {
            iop.reportProgress("Found KGIF version in DOCTYPE: " + kgifMeta);
        } else {
            kgifMeta = KgifManager.detectMetaFromKgifMetadata((IStreamSource)repeatableSource);
            if (kgifMeta != null) {
                iop.reportProgress("Found KGIF version in <header>: " + kgifMeta);
            } else {
                iop.reportProgress("Found no <header> in " + repeatableSource.getSourceName());
            }
        }
        if (kgifMeta == null) {
            return;
        }
        if (kgifMeta.getSchemaVersionNumber().equals("1.1.0")) {
            kgifImporter = new Kgif1_1_0_Importer();
        } else if (kgifMeta.getSchemaVersionNumber().equals("1.0.1")) {
            kgifImporter = new Kgif1_0_1Importer();
        } else if (kgifMeta.getSchemaVersionNumber().equals("1.0.0")) {
            kgifImporter = new Kgif1_0_0Importer();
        } else {
            iop.reportProgress("Source " + repeatableSource.getSourceName() + " is KGIF " + kgifMeta.getSchemaVersionNumber() + " - which we cannot import");
            return;
        }
        kgifImporter.setKgifMeta(kgifMeta);
        map.index(kgifImporter, (Object)1.0);
    }

    private static ScoringMap<IKgifStreamImporter> getImporters(IRepeatableStreamSource repeatableSource, IoProgressReporter iop) {
        ScoringMap map = new ScoringMap();
        ImportManager.scoreImportersByNameAndContentType((ScoringMap<IKgifStreamImporter>)map, repeatableSource.getSourceName(), repeatableSource.getContentType(), iop);
        ImportManager.scoreImportersByContent((ScoringMap<IKgifStreamImporter>)map, repeatableSource, iop);
        return map;
    }

    public static IKgifStreamImporter getImporter(IRepeatableStreamSource repeatableSource, IoProgressReporter iop) {
        ScoringMap<IKgifStreamImporter> map = ImportManager.getImporters(repeatableSource, iop);
        if (map.isEmpty()) {
            return null;
        }
        List topList = map.getTop_SortedBy(true);
        if (topList.size() > 1) {
            iop.reportProgressFailed("Found too many possible importers (we could try them all in a future version)");
        }
        return (IKgifStreamImporter)topList.get(0);
    }

    public static List<IPair<File, IKgifStreamImporter>> listFilesThatAreImportable(DirStore dirStore, IoProgressReporter iop) {
        File[] files;
        ArrayList<IPair<File, IKgifStreamImporter>> list = new ArrayList<IPair<File, IKgifStreamImporter>>();
        for (File f : files = dirStore.getPublicLocalDir().listFiles(FILTER_COULD_BE_IMPORTABLE)) {
            FileStreamSource fileSource = new FileStreamSource(f);
            IKgifStreamImporter importer = ImportManager.getImporter((IRepeatableStreamSource)fileSource, iop);
            if (importer == null) continue;
            iop.reportProgress("Found an importable file: " + f.getAbsolutePath() + " as " + importer.getLabel());
            list.add((IPair<File, IKgifStreamImporter>)Pair.create((Object)f, (Object)importer));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImportResult doImportFromSourceToMyBaseWithImporter(final DirStore dirStore, final IRepeatableStreamSource repeatableSource, IKgifStreamImporter importer, IMyBase myBase, IoProgressReporter iop) throws IOException {
        assert (importer != null);
        repeatableSource.close();
        repeatableSource.setMinBufferSize(0x100000);
        ImportResult importResult = new ImportResult();
        try {
            ImportManager.checkAndTuneEncoding((IStreamSource)repeatableSource, iop);
        }
        catch (IOException e) {
            iop.reportException((Throwable)e);
            return importResult;
        }
        iop.reportProgress("Importing " + repeatableSource.getSourceName() + " as KGIF ... ");
        try {
            if (importer instanceof AbstractImporterToEntityHandler) {
                ((AbstractImporterToEntityHandler)importer).setTempFileProvider(new ITempFileProvider(){

                    public File createTempFile(String localName) {
                        return ImportManager.getKgif1_1_0TempFile(dirStore, (IStreamSource)repeatableSource, localName);
                    }
                });
            }
            IRepeatableStreamSource kgif1_1_0source = importer.convertToKgif1_1_0(repeatableSource, iop);
            assert (kgif1_1_0source != null);
            ImportResult importResult2 = ImportManager.doImportFromKgif1_1_0(dirStore, kgif1_1_0source, myBase, iop);
            return importResult2;
        }
        catch (Throwable t) {
            iop.reportException(t);
            ImportResult importResult3 = importResult;
            return importResult3;
        }
    }

    static {
        DWZ_FILE_EXT.addAll(Arrays.asList(DwzFileFormats.AUTOSAVED_CHANGES.getExtensions()));
        DWZ_FILE_EXT.addAll(Arrays.asList(DwzFileFormats.CACHE.getExtensions()));
        DWZ_FILE_EXT.addAll(Arrays.asList(DwzFileFormats.PROJECT_PROPERTIES.getExtensions()));
        DWZ_FILE_EXT.addAll(Arrays.asList(DwzFileFormats.DIR_LOCK.getExtensions()));
        FILTER_COULD_BE_IMPORTABLE = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return FileTools.IGNORE_GENERATED_FILES.accept(pathname) && !DWZ_FILE_EXT.contains(FilenameUtils.getExtension((File)pathname));
            }
        };
    }
}

