/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.graph2.logical;

import de.xam.dwzmodel.graph2.logical.LogicalGraph;
import de.xam.dwzmodel.graph2.logical.LogicalNode;
import de.xam.dwzmodel.graph2.logical.LogicalPartition;
import de.xam.mybase.model.api.IMyBase;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.xydra.base.XId;
import org.xydra.index.iterator.ITransformer;
import org.xydra.index.iterator.Iterators;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class LogicalGraphs {
    private static final ITransformer<LogicalNode, XId> NODE2ID_TRANSFORMER = new ITransformer<LogicalNode, XId>(){

        public XId transform(LogicalNode in) {
            return in.getItemId();
        }
    };
    public static final int DEFAULT_DEPTH_MAX = 5;
    public static final int DEFAULT_NODES_MAX = 50;
    private static final Logger log = LoggerFactory.getLogger(LogicalGraphs.class);

    public static LogicalGraph explore(IMyBase myBase, SortedSet<XId> centralItemIds, SortedSet<XId> desiredItems, int maxDepth, int maxTotalNodes) {
        LogicalGraph logicalGraph = new LogicalGraph(myBase, centralItemIds, desiredItems);
        int usedMaxDepth = maxDepth == -1 ? 5 : maxDepth;
        int usedMaxNodes = maxTotalNodes == -1 ? 50 : maxTotalNodes;
        logicalGraph.exploreFrontier_v2(logicalGraph.createInitialFrontier(), usedMaxDepth, usedMaxNodes);
        return logicalGraph;
    }

    public static LogicalGraph shrinkNodeCountTo(LogicalGraph logicalGraph, int maxNodes) {
        HashSet<LogicalNode> keep = new HashSet<LogicalNode>();
        if (logicalGraph.getFullyExploredNodeCount() <= maxNodes) {
            Iterators.addAll(logicalGraph.getNodes().iterator(), keep);
        } else if (logicalGraph.getCentralNodes().size() > maxNodes) {
            Iterators.addAll((Iterator)Iterators.limit(logicalGraph.getCentralNodes().iterator(), (int)maxNodes), keep);
        } else if (logicalGraph.getCentralNodes().size() + logicalGraph.getDesiredNodes().size() > maxNodes) {
            keep.addAll(logicalGraph.getCentralNodes());
            Iterators.addAll((Iterator)Iterators.limit(logicalGraph.getDesiredNodes().iterator(), (int)maxNodes), keep);
        } else {
            keep.addAll(logicalGraph.getCentralNodes());
            keep.addAll(logicalGraph.getDesiredNodes());
            Set<LogicalNode> best = LogicalGraphs.getBestConnectingNodes(maxNodes - keep.size(), logicalGraph, keep);
            keep.addAll(best);
            if (keep.size() < maxNodes) {
                Set<LogicalNode> neighbours = LogicalGraphs.getNeighbors(maxNodes - keep.size(), logicalGraph, keep);
                keep.addAll(neighbours);
            }
            log.trace("Keeping " + keep.size() + " nodes");
        }
        HashSet<LogicalNode> shrunkCentralItems = new HashSet<LogicalNode>();
        shrunkCentralItems.addAll(logicalGraph.getCentralNodes());
        shrunkCentralItems.retainAll(keep);
        TreeSet<XId> shrunkCentralItemIds = new TreeSet<XId>();
        Iterators.addAll((Iterator)Iterators.transform(shrunkCentralItems.iterator(), NODE2ID_TRANSFORMER), shrunkCentralItemIds);
        HashSet<LogicalNode> shrunkDesiredItems = new HashSet<LogicalNode>();
        shrunkDesiredItems.addAll(logicalGraph.getDesiredNodes());
        shrunkDesiredItems.retainAll(keep);
        TreeSet<XId> shrunkDesiredItemIds = new TreeSet<XId>();
        Iterators.addAll((Iterator)Iterators.transform(shrunkDesiredItems.iterator(), NODE2ID_TRANSFORMER), shrunkDesiredItemIds);
        LogicalGraph shrunkLogicalGraph = new LogicalGraph(logicalGraph.getMyBase(), shrunkCentralItemIds, shrunkDesiredItemIds);
        for (LogicalNode logicalNode : keep) {
            shrunkLogicalGraph.addLogicalNode(logicalNode);
        }
        int maxFrontierNodesToShowPerNode = 9;
        block1: for (LogicalNode logicalNode : keep) {
            LogicalNode sourceNode = logicalGraph.getNodeById(logicalNode.getItemId());
            for (LogicalNode next : Iterators.from(sourceNode.getLinkedNodes())) {
                if (shrunkLogicalGraph.containsNode(next)) continue;
                LogicalNode nextNode = shrunkLogicalGraph.addLogicalNode(next);
                nextNode.markAsFrontier();
                if (!sourceNode.has_n_orMoreLinkedFrontierNodes(9)) continue;
                continue block1;
            }
        }
        List nodes = Iterators.toList(shrunkLogicalGraph.getNodes().iterator());
        HashSet<LogicalNode> toDelete = new HashSet<LogicalNode>();
        for (LogicalNode logicalNode : nodes) {
            LogicalNode unshrunkNode;
            if (logicalNode.isFrontier() || !(unshrunkNode = logicalGraph.getNodeById(logicalNode.getItemId())).has_n_orMoreLinkedFrontierNodes(9)) continue;
            int i = 0;
            Iterator<LogicalNode> it = unshrunkNode.getLinkedNodes();
            while (it.hasNext()) {
                LogicalNode unshrunkTargetNode = it.next();
                LogicalNode shrunkTargetNode = shrunkLogicalGraph.getNodeById(unshrunkTargetNode.getItemId());
                if (shrunkTargetNode == null || !shrunkTargetNode.isFrontier() || toDelete.contains(shrunkTargetNode)) continue;
                if (i > 9) {
                    toDelete.add(shrunkTargetNode);
                    continue;
                }
                ++i;
            }
        }
        for (LogicalNode logicalNode : toDelete) {
            shrunkLogicalGraph.removeLogicalNode(logicalNode);
        }
        shrunkLogicalGraph.copyLinksFrom(logicalGraph, 1);
        return shrunkLogicalGraph;
    }

    private static Set<LogicalNode> getNeighbors(int desiredResultSize, LogicalGraph logicalGraph, Set<LogicalNode> given) {
        LogicalPartition logicalPartition = new LogicalPartition(logicalGraph);
        for (LogicalNode node : given) {
            logicalPartition.addMemberNode(node);
        }
        HashSet<LogicalNode> result = new HashSet<LogicalNode>();
        int depth = 1;
        boolean growing = true;
        while (result.size() < desiredResultSize && growing) {
            Set<LogicalNode> ring = logicalPartition.getRing(depth);
            int resultSize = result.size();
            Iterators.addFirstN(ring.iterator(), result, (int)(desiredResultSize - resultSize));
            growing = result.size() > resultSize;
            ++depth;
        }
        return result;
    }

    private static Set<LogicalNode> getBestConnectingNodes(int desiredResultSize, LogicalGraph logicalGraph, Set<LogicalNode> given) {
        HashSet<LogicalNode> remainingNodes = new HashSet<LogicalNode>();
        Iterators.addAll(logicalGraph.getNodes().iterator(), remainingNodes);
        remainingNodes.removeAll(given);
        if (desiredResultSize >= remainingNodes.size()) {
            return remainingNodes;
        }
        HashSet<LogicalNode> result = new HashSet<LogicalNode>();
        boolean exploreMore = true;
        while (result.size() < desiredResultSize && exploreMore) {
            LogicalPartition logicalPartition = new LogicalPartition(logicalGraph);
            for (LogicalNode node : given) {
                logicalPartition.addMemberNode(node);
            }
            for (LogicalNode node : result) {
                logicalPartition.addMemberNode(node);
            }
            logicalPartition.mergeDirectNeighbours();
            LogicalNode bestNode = logicalPartition.getBestConnectingNode();
            if (bestNode == null) {
                exploreMore = false;
                continue;
            }
            result.add(bestNode);
        }
        return result;
    }
}

