/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.graph2.logical;

import de.xam.dwzmodel.graph2.logical.LogicalGraph;
import de.xam.dwzmodel.graph2.logical.LogicalNode;
import de.xam.dwzmodel.graph2.visual.VisualNode;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.xydra.index.CollectionUtils;
import org.xydra.index.IEntrySet;
import org.xydra.index.impl.MapSetIndex;

public class LogicalComponent
implements Comparable<LogicalComponent> {
    private final LogicalGraph logicalGraph;
    private final SortedSet<LogicalNode> members = new TreeSet<LogicalNode>();
    private final MapSetIndex<Integer, LogicalNode> rings = MapSetIndex.createWithFastEntrySets();

    public LogicalComponent(LogicalGraph logicalGraph, LogicalNode member) {
        this.logicalGraph = logicalGraph;
        this.members.add(member);
    }

    private void clear() {
        this.members.clear();
        this.rings.clear();
    }

    @Override
    public int compareTo(LogicalComponent o) {
        int i = this.members.size() - o.members.size();
        if (i != 0) {
            return i;
        }
        return this.members.first().compareTo(o.members.first());
    }

    public boolean equals(Object other) {
        if (other instanceof VisualNode) {
            VisualNode o = (VisualNode)other;
            return CollectionUtils.equalSets(this.getMembers(), o.getLogicalNodes());
        }
        return false;
    }

    public Set<LogicalNode> getMembers() {
        return this.members;
    }

    public Set<LogicalNode> getNeighbours(int depth) {
        assert (depth >= 0);
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        if (depth == 0) {
            return this.getMembers();
        }
        IEntrySet ring = this.rings.lookup((Object)depth);
        if (ring == null) {
            Set<LogicalNode> innerRing = this.getNeighbours(depth - 1);
            Set<LogicalNode> inner2Ring = depth >= 2 ? this.getNeighbours(depth - 2) : Collections.EMPTY_SET;
            for (LogicalNode inner : innerRing) {
                Iterator<LogicalNode> outerIt = inner.getLinkedNodes();
                while (outerIt.hasNext()) {
                    LogicalNode outerNode = outerIt.next();
                    if (innerRing.contains(outerNode) || inner2Ring.contains(outerNode)) continue;
                    this.rings.index((Object)depth, (Object)outerNode);
                }
            }
            ring = this.rings.lookup((Object)depth);
        }
        return ring == null ? Collections.EMPTY_SET : ring.toSet();
    }

    public int hashCode() {
        int hash = 1;
        for (LogicalNode n : this.getMembers()) {
            hash *= n.hashCode();
        }
        return hash;
    }

    public boolean isEmpty() {
        return this.members.isEmpty();
    }

    public boolean isMemberUpToDepth(int depth, LogicalNode node) {
        for (int d = 0; d <= depth; ++d) {
            Set<LogicalNode> neighbors = this.getNeighbours(d);
            if (!neighbors.contains(node)) continue;
            return true;
        }
        return false;
    }

    public void mergeIn(LogicalComponent neighbour) {
        this.members.addAll(neighbour.getMembers());
        neighbour.clear();
        this.rings.clear();
    }
}

