/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.graph2;

import de.xam.dwzmodel.graph2.JsonGraphs;
import de.xam.dwzmodel.graph2.calc.VisualGraphMaker;
import de.xam.dwzmodel.graph2.logical.LogicalGraph;
import de.xam.dwzmodel.graph2.logical.LogicalGraphs;
import de.xam.dwzmodel.graph2.visual.VisualGraph;
import de.xam.json.JON;
import de.xam.mybase.model.api.IMyBase;
import java.util.SortedSet;
import org.xydra.base.XId;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class Graphs {
    private static final Logger log = LoggerFactory.getLogger(Graphs.class);

    public static JON createGraphAsJSON(IMyBase myBase, SortedSet<XId> centralItems, SortedSet<XId> desiredItems, int maxDepth, int maxTotalNodes) {
        LogicalGraph logicalGraph = LogicalGraphs.explore(myBase, centralItems, desiredItems, maxDepth, maxTotalNodes);
        log.debug("Reducing the number of logical nodes to ensure visualGraph has not more than " + maxTotalNodes + " nodes");
        LogicalGraph logicalGraph2 = LogicalGraphs.shrinkNodeCountTo(logicalGraph, maxTotalNodes);
        VisualGraph visualGraph3 = VisualGraphMaker.toVisualGraph_2(logicalGraph2);
        assert (VisualGraphMaker.measureEntropy((VisualGraph)visualGraph3).nodeCount <= maxTotalNodes);
        JON jon = JsonGraphs.toJon(visualGraph3);
        return jon;
    }
}

