/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.graph.visual.impl;

import de.xam.dwzmodel.graph.VisualType;
import de.xam.dwzmodel.graph.logical.LogicalLink;
import de.xam.dwzmodel.graph.visual.IVisualLink;
import de.xam.dwzmodel.graph.visual.IVisualNode;
import de.xam.dwzmodel.graph.visual.impl.VisualEntity;
import de.xam.dwzmodel.graph.visual.impl.VisualGraph;
import de.xam.json.JON;

class VisualLink
extends VisualEntity
implements IVisualLink {
    private final LogicalLink logicalLink;
    private final IVisualNode source;
    private final IVisualNode target;

    public VisualLink(VisualGraph graph, LogicalLink link, IVisualNode source, IVisualNode target, JON jsonAttributes) {
        super(graph);
        this.logicalLink = link;
        this.source = source;
        this.target = target;
        if (jsonAttributes != null) {
            this.jsonAttributes.putAll(jsonAttributes);
        }
    }

    @Override
    public VisualType getVisualType() {
        return VisualType.Link;
    }

    public int hashCode() {
        return this.logicalLink.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof IVisualLink) {
            return ((IVisualLink)o).getLogicalLink().equals(this.logicalLink);
        }
        return false;
    }

    public String toString() {
        return "[VLINK '" + this.source.getPrimaryLogicalNode().getBaseEntity().getId() + "'->'" + this.target.getPrimaryLogicalNode().getBaseEntity().getId() + "'] " + this.logicalLink + " ATTS=" + this.jsonAttributes;
    }

    @Override
    public LogicalLink getLogicalLink() {
        return this.logicalLink;
    }

    @Override
    public IVisualNode getStart() {
        if (this.logicalLink.isReversed()) {
            return this.target;
        }
        return this.source;
    }

    @Override
    public IVisualNode getEnd() {
        if (this.logicalLink.isReversed()) {
            return this.source;
        }
        return this.target;
    }

    @Override
    public IVisualNode getOtherEnd(IVisualNode visualNode) {
        if (this.getStart() == visualNode) {
            return this.getEnd();
        }
        assert (this.getEnd() == visualNode);
        return this.getStart();
    }
}

