/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel;

import com.calpano.kgif.io.FileFormat;
import com.calpano.kgif.io.FileFormats;
import com.calpano.kgif.io.IFileFormat;
import com.calpano.kgif.io.common.KnownKgifExporter;
import com.calpano.kgif.io.common.KnownKgifImporter;
import com.calpano.kgif.io.rdf.RdfCommon;
import com.google.common.collect.Sets;
import de.xam.cmodel.fact.ChangeDatas;
import de.xam.cmodel.fact.IChangeData;
import de.xam.dwzmodel.api.ConfParamsDwzModel;
import de.xam.dwzmodel.state.ModuleManager;
import de.xam.itemset.CDS;
import de.xam.itemset.IEntity;
import de.xam.itemset.IItem;
import de.xam.itemset.IItemSet;
import de.xam.itemset.IItemSource;
import de.xam.itemset.IProperty;
import de.xam.itemset.IStatement;
import de.xam.itemset.impl.ItemSets;
import de.xam.itemset.impl.Items;
import de.xam.itemset.index.IItemSetManagedIndex;
import de.xam.itemset.index.IndexManager;
import de.xam.kfacet.IFacet;
import de.xam.kfacet.KFacets;
import de.xam.kfacet.impl.wiki.WikiFacet;
import de.xam.kfacet.impl.wiki.WikiItem;
import de.xam.kfacet.impl.wiki.WikiRender;
import de.xam.kfacet.impl.wiki.spi.IEntity2Href;
import de.xam.mybase.model.IoProgressReporter;
import de.xam.mybase.model.Labeler;
import de.xam.mybase.model.MyBases;
import de.xam.mybase.model.api.IMyBase;
import de.xam.mybase.model.api.MyBaseComponent;
import de.xam.mybase.model.inference.IInfModel;
import de.xam.mybase.model.names.IdManager;
import de.xam.mybase.model.search.SearchEngines;
import de.xam.tagcloud.Frequency;
import de.xam.texthtml.css.CssTool;
import de.xam.texthtml.text.JspWikiSyntax;
import de.xam.texthtml.text.TextTool;
import de.xam.textsearch.Match;
import de.xam.textsearch.compare.LexicographicContentComperator;
import de.xam.textsearch.spi.IContentResolver;
import de.xam.tokenpipe.user.pipe.link.spi.ILinkListener;
import de.xam.vocabulary.Vocabularies;
import de.xam.vocabulary.Vocabulary;
import de.xam.vocabulary.VocabularyTerm;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xydra.base.Base;
import org.xydra.base.XId;
import org.xydra.base.value.XValue;
import org.xydra.conf.IConfig;
import org.xydra.conf.annotations.RequireConf;
import org.xydra.env.Env;
import org.xydra.index.impl.IntegerRange;
import org.xydra.index.impl.TripleUtils;
import org.xydra.index.iterator.ClosableIterator;
import org.xydra.index.iterator.IFilter;
import org.xydra.index.iterator.ITransformer;
import org.xydra.index.iterator.Iterators;
import org.xydra.index.query.Pair;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.log.impl.universal.UniversalLogger;
import org.xydra.restless.IMultipartFormDataHandler;
import org.xydra.restless.ProgressManager;
import org.xydra.sharedutils.XyAssert;

@RequireConf(value={"knowledgeFileRootDir"})
public class DwzModel {
    private static final Logger log = LoggerFactory.getLogger(DwzModel.class);
    public static final char[] PREFETCH_CHARS = "abcdefghijklmnopqrstuvwxyz0123456789_.-+#\u00e4\u00f6\u00fc!?".toCharArray();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Match<XId>> autocompleteMatches(String prefix, int maxResults, IFilter<XId> optionalPreferredFilter) {
        List list;
        assert (prefix != null);
        try {
            List matches;
            ModuleManager.get().locks(MyBaseComponent.SearchEngine, MyBaseComponent.TripleStats).readLock().lock();
            IMyBase myBase = ModuleManager.get().getMyBase();
            list = matches = MyBases.searchItemsAutocomplete((IMyBase)myBase, (String)prefix, (int)maxResults, optionalPreferredFilter);
        }
        catch (Throwable throwable) {
            ModuleManager.get().locks(MyBaseComponent.SearchEngine, MyBaseComponent.TripleStats).readLock().unlock();
            throw throwable;
        }
        ModuleManager.get().locks(MyBaseComponent.SearchEngine, MyBaseComponent.TripleStats).readLock().unlock();
        return list;
    }

    public static Set<Match<XId>> autocompletePrefetchMatches(IFilter<XId> optionalPreferredFilter) {
        HashSet<Match<XId>> matches = new HashSet<Match<XId>>();
        for (char c : PREFETCH_CHARS) {
            matches.addAll(DwzModel.autocompleteMatches("" + c, 40, optionalPreferredFilter));
        }
        return matches;
    }

    public static void bootForTests() {
        DwzModel.configureForTests();
        IoProgressReporter iop = IoProgressReporter.createOnLogInfo((Logger)log);
        ModuleManager.get().boot(iop);
    }

    public static boolean canBeDeleted(XId itemId) {
        IItem item = DwzModel.getMyBase().itemSet().getItemById(itemId);
        if (item == null) {
            return false;
        }
        return Items.canBeDeleted((IEntity)item);
    }

    public static void configureForTests() {
        log.info("DWZ model prepare for tests ................");
        UniversalLogger.activate();
        IConfig conf = Env.get().conf();
        new ConfParamsDwzModel().configureDefaults(conf);
        conf.setAs("appName", (Object)"dwz-testing");
        conf.setBoolean("template-inProduction", false);
        XyAssert.setEnabled((boolean)true);
    }

    private static void deIndex(XId itemId, Frequency<XId> f) {
        assert (itemId != null);
        f.remove((Comparable)itemId);
    }

    public static void deleteOldStuff(IMyBase myBase, IoProgressReporter iop) {
        String[] oldIds;
        IChangeData changeData = ChangeDatas.createWithLastModifiedDate_Now((String)"DWZ", (String)"deleteOldStuff");
        Iterator it = Vocabularies.iterator();
        while (it.hasNext()) {
            Vocabulary voc = (Vocabulary)it.next();
            if (voc.getNamespace() == null) continue;
            for (VocabularyTerm term : voc.terms()) {
                XId id = term.id();
                if (voc.getNamespace().equals("cds") && (term.getPrefix() == null || !term.getPrefix().equals("prop"))) continue;
                ItemSets.deleteEntity((IItemSet)myBase.itemSet(), (XId)id, (IChangeData)changeData);
            }
        }
        for (String s : oldIds = new String[]{"autolink", "wikilink", "wikiword", "url", "contexthidden", "contexthiddenlevel", "contextmarkerend", "vocabulary-item-dummy", "vocabulary-rel-hasTerm", "vocabulary-dwz", "vocabulary-cds", "vocabulary-mybase", "vocabulary-wiki", "vocabulary-pmodel", "vocabulary-contextgraph", "dwz-prop-camelCased", "dwz-prop-contentLength", "dwz-prop-createdBy", "dwz-prop-creationDate", "dwz-prop-lastModified", "dwz-rel-usesProperty", "WikiFacet", "jspwiki-prop-jspwikiLastModified", "jspwiki-prop-version", "source-datafile", "source-jspwiki", "sources-prop-indexStats", "wiki-prop-autolinkTarget", "wiki-prop-version", "wiki-prop-wikitext", "facet-wiki"}) {
            XId id = Base.toId((String)s);
            ItemSets.deleteEntity((IItemSet)myBase.itemSet(), (XId)id, (IChangeData)changeData);
        }
        log.info("Rename some ids");
        HashMap<XId, XId> rename = new HashMap<XId, XId>();
        rename.put(Base.toId((String)"cds-rel-type_relation"), Base.toId((String)"cds-item-type_relation"));
        rename.put(Base.toId((String)"cds-rel-type_symmetricRelation"), Base.toId((String)"cds-item-type_symmetricRelation"));
        rename.put(Base.toId((String)"cds-rel-type_transitiveRelation"), Base.toId((String)"cds-item-type_transitiveRelation"));
        myBase.itemSet().renameIds(rename);
        log.info("Done with delete old stuff");
    }

    public static Collection<IFacet> facets() {
        return KFacets.facets();
    }

    public static IEntity2Href getEntity2Href() {
        IConfig conf = Env.get().conf();
        return (IEntity2Href)conf.resolve(IEntity2Href.class);
    }

    public static List<FileFormat> getExportFileFormatsList() {
        ArrayList<FileFormat> list = new ArrayList<FileFormat>();
        list.add(FileFormats.KGIF_1_1_0);
        list.add(RdfCommon.FILEFORMAT_RDF_XML);
        list.add(RdfCommon.FILEFORMAT_RDF_NTRIPLES);
        Collections.sort(list);
        KnownKgifExporter.init();
        for (FileFormat ff : list) {
            assert (KnownKgifExporter.isKnownExportFormat((FileFormat)ff)) : "you reported '" + ff + "' as export file format, but have not registered an exporter";
        }
        return list;
    }

    public static List<FileFormat> getImportFileFormatsList() {
        ArrayList<FileFormat> list = new ArrayList<FileFormat>();
        list.add(FileFormats.KGIF_1_1_0);
        list.add(RdfCommon.FILEFORMAT_RDF_XML);
        list.add(RdfCommon.FILEFORMAT_RDF_NTRIPLES);
        Collections.sort(list);
        KnownKgifImporter.init();
        for (FileFormat ff : list) {
            assert (KnownKgifImporter.isKnownImportFormat((IFileFormat)ff)) : "you reported '" + ff + "' as import file format, but have not registered an importer";
        }
        return list;
    }

    public static IMyBase getMyBase() {
        return ModuleManager.get().getMyBase();
    }

    public static String getTagCloud(IMyBase myBase, boolean showBuiltIns, IntegerRange freqRange, int tagNumber) {
        String string;
        Frequency<XId> fItems = DwzModel.measure(myBase, true, true, false, false, showBuiltIns);
        Frequency<XId> fRels = DwzModel.measure(myBase, false, false, true, false, showBuiltIns);
        Frequency<XId> fProps = DwzModel.measure(myBase, false, false, false, true, showBuiltIns);
        StringWriter sw = new StringWriter();
        ITransformer<XId, String> transformer = new ITransformer<XId, String>(){

            public String transform(XId itemId) {
                StringBuilder link = DwzModel.toLink(itemId, ILinkListener.LinkCause.app, "tagcloud-item");
                return link.toString();
            }
        };
        ModuleManager.get().locks(MyBaseComponent.ItemSet).readLock().lock();
        try {
            HashSet blacklist = Sets.newHashSet();
            boolean caseMatters = false;
            final IItemSet itemSet = myBase.itemSet();
            Comparator<XId> comparator = new Comparator<XId>(){

                @Override
                public int compare(XId aId, XId bId) {
                    String a = ItemSets.getContent((IItemSet)itemSet, (XId)aId);
                    String b = ItemSets.getContent((IItemSet)itemSet, (XId)bId);
                    return TextTool.compare((String)a, (String)b, (boolean)false);
                }
            };
            sw.write("<h3>Items</h3>");
            sw.write("<p class='about'>All items (" + (showBuiltIns ? "including" : "excluding") + " built-ins" + "), ranked by usage in links</p>");
            fItems.writeToTagCloud((Writer)sw, freqRange, tagNumber, (Set)blacklist, (ITransformer)transformer, (Comparator)comparator);
            sw.write("<h3>Relations</h3>");
            sw.write("<p class='about'>All items used as relations (" + (showBuiltIns ? "plus" : "excluding") + " built-in relations" + "), ranked by usage</p>");
            fRels.writeToTagCloud((Writer)sw, freqRange, tagNumber, (Set)blacklist, (ITransformer)transformer, (Comparator)comparator);
            sw.write("<h3>Properties</h3>");
            sw.write("<p class='about'>All used properties, ranked by usage</p>");
            fProps.writeToTagCloud((Writer)sw, freqRange, tagNumber, (Set)blacklist, (ITransformer)transformer, (Comparator)comparator);
            string = sw.toString();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Error", e);
            }
            catch (Throwable throwable) {
                ModuleManager.get().locks(MyBaseComponent.ItemSet).readLock().unlock();
                throw throwable;
            }
        }
        ModuleManager.get().locks(MyBaseComponent.ItemSet).readLock().unlock();
        return string;
    }

    protected static WikiFacet getWikiFacet() {
        return ModuleManager.get().getWikiFacet();
    }

    public static String getWikiSource(XId itemId) throws IOException {
        if (itemId == null) {
            return null;
        }
        IItem item = DwzModel.getMyBase().itemSet().getItemById(itemId);
        String source = WikiItem.getWikiSource((IItem)item);
        return source;
    }

    public static Pair<String, Long> getWikiSourceAndVersion(XId itemId, int start, int end) throws IOException {
        IItem item = DwzModel.getMyBase().itemSet().getItemById(itemId);
        return WikiItem.getWikiSourceAndVersion((IItem)item, (int)start, (int)end);
    }

    private static void index(XId itemId, Frequency<XId> f) {
        assert (itemId != null);
        f.index((Comparable)itemId, Collections.EMPTY_SET);
    }

    public static boolean isIri(String s) {
        return JspWikiSyntax.isIri((String)s);
    }

    public static Frequency<XId> measure(IMyBase myBase, boolean itemNames, boolean so, boolean rels, boolean props, boolean showBuiltins) {
        Frequency f = new Frequency();
        IItemSet itemSet = myBase.itemSet();
        HashSet<XId> builtInEntities = new HashSet<XId>();
        Iterator it = itemSet.items();
        int itemCount = 0;
        while (it.hasNext()) {
            IItem item = (IItem)it.next();
            if (!Items.canBeDeleted((IEntity)item)) {
                builtInEntities.add(item.getId());
                if (!showBuiltins) continue;
            }
            if (itemNames) {
                DwzModel.index(item.getId(), (Frequency<XId>)f);
            }
            ++itemCount;
        }
        int stmtCount = 0;
        Iterator stmtIt = itemSet.statements();
        while (stmtIt.hasNext()) {
            XId relationId;
            IStatement stmt = (IStatement)stmtIt.next();
            if (!showBuiltins && !Items.canBeDeleted((IEntity)stmt)) continue;
            if (so && !(relationId = stmt.getTriple().p()).equals(CDS.INSTANCE.hasAutoLinkTarget) && !relationId.equals(CDS.INSTANCE.hasAutoLinkSource)) {
                XId subjectId = stmt.getTriple().s();
                if (showBuiltins || !builtInEntities.contains(subjectId)) {
                    DwzModel.index(subjectId, (Frequency<XId>)f);
                }
                XId objectId = stmt.getTriple().o();
                if (showBuiltins || !builtInEntities.contains(objectId)) {
                    DwzModel.index(objectId, (Frequency<XId>)f);
                }
            }
            if (rels) {
                relationId = stmt.getTriple().p();
                if (showBuiltins || !builtInEntities.contains(relationId)) {
                    DwzModel.index(relationId, (Frequency<XId>)f);
                }
            }
            ++stmtCount;
        }
        int propCount = 0;
        Iterator propIt = itemSet.properties();
        while (propIt.hasNext()) {
            IProperty property = (IProperty)propIt.next();
            assert (property.getWritableContent().getContentValue() != null);
            if (!Items.canBeDeleted((IEntity)property)) continue;
            if (so) {
                DwzModel.index(property.getSourceEntityId(), (Frequency<XId>)f);
            }
            if (props) {
                DwzModel.index(property.getPropertyKey(), (Frequency<XId>)f);
            }
            ++propCount;
        }
        if (rels | itemNames) {
            Iterator baseIt = myBase.infModel().getTriples(null, (XId)CDS.INSTANCE.hasType, (XId)CDS.INSTANCE.type_relation);
            ITransformer transformer = TripleUtils.transformer_s();
            ClosableIterator relIt = Iterators.transform((Iterator)baseIt, (ITransformer)transformer);
            while (relIt.hasNext()) {
                XId relId = (XId)relIt.next();
                if (rels) {
                    DwzModel.index(relId, (Frequency<XId>)f);
                }
                if (!itemNames) continue;
                DwzModel.deIndex(relId, (Frequency<XId>)f);
            }
            relIt.close();
        }
        log.debug("Indexed " + itemCount + " items and " + stmtCount + " statements and " + propCount + " properties");
        return f;
    }

    public static void parseWikiContent(IItemSource itemSource, IMyBase myBase, IoProgressReporter iop) {
        log.info("Parsing Wiki syntax of " + itemSource.itemCount() + " items");
        IEntity2Href entity2Href = DwzModel.getEntity2Href();
        iop.reportProgress("Create name index 1:1");
        myBase.indexManager().setUpdating((IItemSetManagedIndex)myBase.nameIndex(), true);
        myBase.indexManager().getIndexState((IItemSetManagedIndex)myBase.nameIndex()).ensureIsComputed((IndexManager.IIndexProgress)iop);
        myBase.indexManager().getIndexState((IItemSetManagedIndex)myBase.nameIndex()).assertIs_computed_updating(Boolean.valueOf(true), Boolean.valueOf(true));
        int count = 0;
        iop.reportProgress("Step 1: Parse manual links");
        boolean createManualLinks = true;
        boolean createAutoLinks = false;
        boolean generateHtml = false;
        count += DwzModel.parseWikiContent_(myBase, itemSource, entity2Href, true, false, false, iop);
        iop.reportProgress("Create name index fragmentized");
        myBase.indexManager().setUpdating((IItemSetManagedIndex)myBase.itemContentIndex(), true);
        myBase.indexManager().getIndexState((IItemSetManagedIndex)myBase.itemContentIndex()).ensureIsComputed((IndexManager.IIndexProgress)iop);
        myBase.indexManager().getIndexState((IItemSetManagedIndex)myBase.nameIndex()).assertIs_computed_updating(Boolean.valueOf(true), Boolean.valueOf(true));
        myBase.indexManager().getIndexState((IItemSetManagedIndex)myBase.itemContentIndex()).assertIs_computed_updating(Boolean.valueOf(true), Boolean.valueOf(true));
        count = 0;
        ProgressManager.reportProgress((IMultipartFormDataHandler.IProgressReporter)iop, (String)"Step 2: Create auto-links");
        createManualLinks = false;
        createAutoLinks = true;
        generateHtml = false;
        log.info("Wiki parsing done, items=" + (count += DwzModel.parseWikiContent_(myBase, itemSource, entity2Href, false, true, false, iop)));
    }

    private static int parseWikiContent_(IMyBase myBase, IItemSource itemSource, IEntity2Href entity2Href, boolean createManualLinks, boolean createAutoLinks, boolean generateHtml, IoProgressReporter iop) {
        int count = 0;
        Iterator itemIt = itemSource.items();
        Set items = Iterators.toSet((Iterator)itemIt);
        for (IItem item : items) {
            String wikiSource = WikiItem.getWikiSource((IItem)item);
            WikiFacet.parseToHtmlWithSideEffects((IMyBase)myBase, (IEntity2Href)entity2Href, (IItem)item, (String)wikiSource, (boolean)createManualLinks, (boolean)createAutoLinks, (boolean)generateHtml);
            if (++count % 1000 != 0) continue;
            iop.reportProgress("Processed " + count + " items ...");
        }
        return count;
    }

    public static List<Match<XId>> searchSubitems(IMyBase myBase, XId itemId, int maxResults, IFilter<XId> optionalFilter) {
        assert (itemId != null);
        IItem item = myBase.itemSet().getItemById(itemId);
        if (item == null) {
            return Collections.emptyList();
        }
        String query = DwzModel.toDisplayStringOrIdString(myBase, itemId);
        return MyBases.searchSubitems((IMyBase)myBase, (String)query, (int)maxResults, optionalFilter);
    }

    public static void shutdownInTests() {
        ModuleManager.get().reset();
        Env.reset();
        log.info("DWZ model shut down");
    }

    public static void sortByContent(List<XId> idList) {
        IContentResolver contentResolver = DwzModel.getMyBase().contentResolver();
        LexicographicContentComperator comparator = new LexicographicContentComperator(contentResolver);
        Collections.sort(idList, comparator);
    }

    public static String toDisplayStringOrIdString(IMyBase myBase, XId itemId) {
        String result = Items.getDisplayString((IItemSet)myBase.itemSet(), (XId)itemId);
        if (result == null) {
            result = itemId.toString();
        }
        return result;
    }

    public static StringBuilder toHighlightLink(IItem item, String linkCause, Match<XId> match) {
        assert (item != null);
        String content = item.getDisplayString();
        assert (content != null) : "null content for item '" + item.getId() + "'";
        boolean caseMatters = false;
        String linkTextHtml = SearchEngines.highlight(match, (String)content, (boolean)false);
        IMyBase myBase = DwzModel.getMyBase();
        return WikiRender.createLinkAsHtml((IItemSet)myBase.itemSet(), (IInfModel)myBase.infModel(), (IItem)item, (String)linkTextHtml, (ILinkListener.LinkCause)ILinkListener.LinkCause.valueOf((String)linkCause), (boolean)false, (IEntity2Href)DwzModel.getEntity2Href(), (String[])new String[0]);
    }

    public static StringBuilder toHighlightLink(String linkCause, Match<XId> match) {
        IItem item = DwzModel.getMyBase().itemSet().getItemById((XId)match.getValue());
        assert (item != null);
        return DwzModel.toHighlightLink(item, linkCause, match);
    }

    public static String toHtml(Iterator<XId> itemIdIt, String cssRootClasses) {
        StringBuilder b = new StringBuilder();
        b.append("<ol class=\"" + cssRootClasses + "\">\n");
        while (itemIdIt.hasNext()) {
            XId itemId = itemIdIt.next();
            b.append("  <li class=\"item \">\n");
            b.append((CharSequence)DwzModel.toLink(itemId, "dwz", new String[0]));
            b.append("  </li>\n");
        }
        b.append("</ol>\n");
        return b.toString();
    }

    public static StringBuilder toLink(IItem item, ILinkListener.LinkCause linkCause, String ... cssClasses) {
        String linkText = Labeler.toLabel((IItem)item);
        IMyBase myBase = DwzModel.getMyBase();
        return WikiRender.createLinkAsHtml((IItemSet)myBase.itemSet(), (IInfModel)myBase.infModel(), (IItem)item, (String)linkText, (ILinkListener.LinkCause)linkCause, (boolean)true, (IEntity2Href)DwzModel.getEntity2Href(), (String[])cssClasses);
    }

    public static StringBuilder toLink(IItem item, String linkCause, String ... cssClasses) {
        return DwzModel.toLink(item, ILinkListener.LinkCause.valueOf((String)linkCause), cssClasses);
    }

    public static StringBuilder toLink(IProperty property, ILinkListener.LinkCause linkCause, String ... cssClasses) {
        assert (property.getWritableContent().getContentValue() != null);
        XValue value = property.getPropertyValue();
        String linkText = Labeler.toLabel((XValue)value);
        String href = DwzModel.getEntity2Href().getViewItemUrl(property.getId());
        HashSet cssClass = Sets.newHashSet((Object[])cssClasses);
        HashMap dataAtts = new HashMap();
        return WikiRender.toHtml((XId)property.getId(), (Set)cssClass, dataAtts, (String)linkText, (boolean)true, (String)href);
    }

    public static StringBuilder toLink(IStatement statement, ILinkListener.LinkCause linkCause, String ... cssClasses) {
        String linkText = Labeler.toLabel((XValue)statement.getId());
        String href = DwzModel.getEntity2Href().getViewItemUrl(statement.getId());
        HashSet cssClass = Sets.newHashSet((Object[])cssClasses);
        HashMap dataAtts = new HashMap();
        return WikiRender.toHtml((XId)statement.getId(), (Set)cssClass, dataAtts, (String)linkText, (boolean)true, (String)href);
    }

    public static StringBuilder toLink(XId entityId, ILinkListener.LinkCause linkCause, String ... cssClasses) {
        IEntity entity = DwzModel.getMyBase().itemSet().getEntityById(entityId);
        if (entity == null) {
            return WikiRender.createNakedLinkAsHtml((XId)entityId, (String)IdManager.toLabel((XId)entityId), (String)(linkCause + " noitem"), (IEntity2Href)DwzModel.getEntity2Href());
        }
        assert (entity != null) : "id=" + entityId;
        if (entity instanceof IItem) {
            return DwzModel.toLink((IItem)entity, linkCause, cssClasses);
        }
        if (entity instanceof IProperty) {
            return DwzModel.toLink((IProperty)entity, linkCause, cssClasses);
        }
        assert (entity instanceof IStatement);
        IStatement stmt = (IStatement)entity;
        return DwzModel.toLink(stmt, linkCause, cssClasses);
    }

    public static StringBuilder toLink(XId entityId, String linkCause, String ... cssClasses) {
        return DwzModel.toLink(entityId, ILinkListener.LinkCause.valueOf((String)linkCause), cssClasses);
    }

    public static StringBuilder toLink_Value(XValue value, String linkCause, String ... cssClasses) {
        if (value instanceof XId) {
            return DwzModel.toLink((XId)value, linkCause, cssClasses);
        }
        StringBuilder b = new StringBuilder();
        b.append("<code class='" + CssTool.toCssClassString((String[])cssClasses, (String[])new String[]{"value"}) + "'>");
        b.append(TextTool.toLimitedString((Object)value, (int)80));
        b.append("</code>");
        return b;
    }

    public static XId toRawId(String idString) {
        return IdManager.toFastRawId((String)idString);
    }

    public static List<XId> toSortedList(Iterator<XId> idIt) {
        ArrayList list = Iterators.toArrayList(idIt);
        Collections.sort(list);
        return list;
    }
}

