/*
 * Decompiled with CFR 0.152.
 */
package de.xam.texthtml.text;

import org.xydra.core.util.RegExUtil;

public class Wikisyntax {
    public static final String bold = RegExUtil.regexEncode((String)"__");
    public static final String italic = RegExUtil.regexEncode((String)"''");
    public static final String linkStart = RegExUtil.regexEncode((String)"[");
    public static final String linkEnd = RegExUtil.regexEncode((String)"]");
    public static final String linkLabelSep = "(?: |" + RegExUtil.regexEncode((String)"|") + ")";
    public static final String item = RegExUtil.regexEncode((String)"*") + " ?";
    public static final String h2 = RegExUtil.regexEncode((String)"==") + "|" + RegExUtil.regexEncode((String)"!!!");
    public static final String h3 = RegExUtil.regexEncode((String)"===") + "|" + RegExUtil.regexEncode((String)"!!");
    public static final String h4 = RegExUtil.regexEncode((String)"====") + "|" + RegExUtil.regexEncode((String)"!");
    public static final String START_OF_LINE = "^";
    public static final String END_OF_LINE = "$";
    private static final String MULTILINEMODE = "(?sm)";

    public static String toHtml(String wikisyntax) {
        String result = wikisyntax;
        result = result.replaceAll("(?sm)^" + item + "(.*?)" + END_OF_LINE, "<li>$1</li>");
        result = result.replaceAll("(?sm)(^<li>.*?</li>\\s*)++", "<ul>$0</ul>");
        result = result.replaceAll(MULTILINEMODE + bold + "(.*?)" + bold, "<strong>$1</strong>");
        result = result.replaceAll(MULTILINEMODE + italic + "(.*?)" + italic, "<emph>$1</emph>");
        result = result.replaceAll(MULTILINEMODE + linkStart + "(.+?)" + linkLabelSep + "(.+?)" + linkEnd, "<a href=\"$1\">$2</a>");
        result = result.replaceAll(MULTILINEMODE + linkStart + "(.+?)" + linkEnd, "<a href=\"$1\">$1</a>");
        return result;
    }
}

