/*
 * Decompiled with CFR 0.152.
 */
package de.xam.texthtml.text;

import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import org.xydra.index.IIntegerRangeIndex;
import org.xydra.index.impl.IntegerRangeIndex;

public class Unicodes {
    private static final IIntegerRangeIndex BROKEN_UTF8;
    public static final IntegerRangeIndex unicodeMixed;
    public static final IntegerRangeIndex unicodeOther;
    public static final IntegerRangeIndex unicodePureSeparator;
    public static final IntegerRangeIndex unicodeSeparator_or_mixed;
    public static final IntegerRangeIndex unicodeText_or_mixed;
    public static final IntegerRangeIndex unicodePureText;
    public static final IntegerRangeIndex unicodeNoName;
    public static final Charset UTF8;
    public static final IntegerRangeIndex unicodeControl;
    public static final IntegerRangeIndex legalEncouragedXml10;
    public static final IntegerRangeIndex unicodeUpperCase;
    public static final IntegerRangeIndex unicodeLowerCase;
    public static final String[] CATEGORY_CODE;
    public static final String[] CATEGORY_NAMES;

    public static boolean isMixed(int codePoint) {
        return unicodeMixed.isInInterval(codePoint);
    }

    public static boolean isOther(int codePoint) {
        return unicodeOther.isInInterval(codePoint);
    }

    public static boolean isSeparator(int codePoint) {
        return unicodePureSeparator.isInInterval(codePoint);
    }

    public static boolean isText(int codePoint) {
        return unicodePureText.isInInterval(codePoint);
    }

    public static boolean looksLikeBrokenUTF8(String s) {
        return IntegerRangeIndex.isAnyCharacterInIntervals((IIntegerRangeIndex)BROKEN_UTF8, (String)s);
    }

    public static char toBroadUnicodeCategory(int codePoint) {
        if (Unicodes.isText(codePoint)) {
            return 'T';
        }
        if (Unicodes.isSeparator(codePoint)) {
            return '_';
        }
        if (Unicodes.isMixed(codePoint)) {
            return 'm';
        }
        if (Unicodes.isOther(codePoint)) {
            return '?';
        }
        throw new AssertionError((Object)"unicode interval setup is not complete");
    }

    public static KindOfCharacter getKindOfCharacter(int codepoint) {
        if (Character.isLowerCase(codepoint)) {
            return KindOfCharacter.Lowercase;
        }
        if (Character.isUpperCase(codepoint)) {
            return KindOfCharacter.Uppercase;
        }
        if (Character.isDigit(codepoint)) {
            return KindOfCharacter.Digit;
        }
        return KindOfCharacter.None;
    }

    public static void dumpAnalysisCodepoint(int codepoint) {
        int type = Character.getType(codepoint);
        System.out.println("Codepoint=" + codepoint + " Name='" + Character.getName(codepoint) + "'" + " Type " + type + "=" + CATEGORY_CODE[type] + " " + CATEGORY_NAMES[type] + " Dir=" + Character.getDirectionality(codepoint) + " Char='" + (char)codepoint + "'");
    }

    public static void main(String[] args) {
        Iterator rIt = unicodeControl.rangesIterator();
        while (rIt.hasNext()) {
            Map.Entry e = (Map.Entry)rIt.next();
            for (int i = ((Integer)e.getKey()).intValue(); i <= (Integer)e.getValue(); ++i) {
                Unicodes.dumpAnalysisCodepoint(i);
            }
        }
    }

    public static boolean isSurrogate(char c) {
        return '\ud800' <= c && c <= '\udfff';
    }

    public static boolean isHighSurrogate(char c) {
        return '\ud800' <= c && c <= '\udbff';
    }

    public static boolean isLowSurrogate(char c) {
        return c >= '\udc00' && c <= '\udfff';
    }

    static {
        unicodeMixed = new IntegerRangeIndex();
        unicodeOther = new IntegerRangeIndex();
        unicodePureSeparator = new IntegerRangeIndex();
        unicodeSeparator_or_mixed = new IntegerRangeIndex();
        unicodeText_or_mixed = new IntegerRangeIndex();
        unicodePureText = new IntegerRangeIndex();
        unicodeNoName = new IntegerRangeIndex();
        UTF8 = Charset.forName("UTF-8");
        unicodeControl = new IntegerRangeIndex();
        legalEncouragedXml10 = new IntegerRangeIndex();
        unicodeUpperCase = new IntegerRangeIndex();
        unicodeLowerCase = new IntegerRangeIndex();
        legalEncouragedXml10.index(9);
        legalEncouragedXml10.index(10);
        legalEncouragedXml10.index(13);
        legalEncouragedXml10.index(32, 55295);
        legalEncouragedXml10.index(57344, 65533);
        legalEncouragedXml10.index(65536, 0x10FFFF);
        block8: for (int i = 0; i < 0x10FFFF; ++i) {
            if (Character.isUpperCase(i)) {
                unicodeUpperCase.index(i);
            }
            if (Character.isLowerCase(i)) {
                unicodeLowerCase.index(i);
            }
            int type = Character.getType(i);
            switch (type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 26: 
                case 27: {
                    unicodePureText.index(i);
                    continue block8;
                }
                case 15: {
                    unicodeControl.index(i);
                }
                case 13: 
                case 14: {
                    unicodeNoName.index(i);
                }
                case 12: {
                    unicodePureSeparator.index(i);
                    continue block8;
                }
                case 6: 
                case 7: 
                case 16: 
                case 18: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 28: 
                case 29: 
                case 30: {
                    unicodeMixed.index(i);
                    continue block8;
                }
                case 0: 
                case 19: {
                    unicodeOther.index(i);
                }
            }
        }
        unicodeSeparator_or_mixed.addAll((IIntegerRangeIndex)unicodePureSeparator);
        unicodeSeparator_or_mixed.addAll((IIntegerRangeIndex)unicodeMixed);
        unicodeText_or_mixed.addAll((IIntegerRangeIndex)unicodePureText);
        unicodeText_or_mixed.addAll((IIntegerRangeIndex)unicodeMixed);
        BROKEN_UTF8 = new IntegerRangeIndex();
        BROKEN_UTF8.index(128, 159);
        CATEGORY_CODE = new String[]{"Cn", "Lu", "Ll", "Lt", "Lm", "Lo", "Mn", "Me", "Mc", "Nd", "Nl", "No", "Zs", "Zl", "Zp", "Cc", "Cf", "??NoCode", "Co", "Cs", "Pd", "Ps", "Pe", "Pc", "Po", "Sm", "Sc", "Sk", "So", "Pi", "Pf"};
        CATEGORY_NAMES = new String[]{"UNASSIGNED", "UPPERCASE_LETTER", "LOWERCASE_LETTER", "TITLECASE_LETTER", "MODIFIER_LETTER", "OTHER_LETTER", "NON_SPACING_MARK", "ENCLOSING_MARK", "COMBINING_SPACING_MARK", "DECIMAL_DIGIT_NUMBER", "LETTER_NUMBER", "OTHER_NUMBER", "SPACE_SEPARATOR", "LINE_SEPARATOR", "PARAGRAPH_SEPARATOR", "CONTROL", "FORMAT", "??NoCategory", "PRIVATE_USE", "SURROGATE", "DASH_PUNCTUATION", "START_PUNCTUATION", "END_PUNCTUATION", "CONNECTOR_PUNCTUATION", "OTHER_PUNCTUATION", "MATH_SYMBOL", "CURRENCY_SYMBOL", "MODIFIER_SYMBOL", "OTHER_SYMBOL", "INITIAL_QUOTE_PUNCTUATION", "FINAL_QUOTE_PUNCTUATION"};
    }

    public static enum KindOfCharacter {
        Digit,
        Lowercase,
        None,
        Uppercase;

    }
}

