/*
 * Decompiled with CFR 0.152.
 */
package de.xam.texthtml.text;

import de.xam.texthtml.text.Unicodes;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xydra.annotations.LicenseApache;
import org.xydra.conf.escape.Escaping;
import org.xydra.index.IIntegerRangeIndex;
import org.xydra.index.impl.DebugUtils;
import org.xydra.index.impl.IntegerRangeIndex;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.sharedutils.URLUtils;

public class TextTool {
    public static final char ESCAPE = '\\';
    private static final Logger log = LoggerFactory.getLogger(TextTool.class);
    public static final String MARKER_CLOSE = " <__ ";
    public static final String MARKER_OPEN = " __> ";
    public static final String REGEX_VAR = "(?s).*((?:\\$\\{([^}]+)\\})|(?:xxx-([^-]+)-xxx)).*";
    public static final Pattern REGEX_VAR_PATTERN = Pattern.compile("(?s).*((?:\\$\\{([^}]+)\\})|(?:xxx-([^-]+)-xxx)).*");

    public static boolean codepointIsOneOf(int codepoint, String manyCodepoints) {
        return manyCodepoints.contains("" + (char)codepoint);
    }

    public static boolean contains(Set<String> set, String s, boolean caseMatters) {
        assert (set != null);
        if (caseMatters) {
            return set.contains(s);
        }
        for (String t : set) {
            if (!TextTool.equals(t, s, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(String s, String part, boolean caseMatters) {
        assert (s != null);
        assert (part != null);
        if (caseMatters) {
            return s.contains(part);
        }
        return s.toLowerCase().contains(part.toLowerCase());
    }

    public static boolean containsOneOf(String string, char[] chars) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (chars == null) {
            throw new IllegalArgumentException("char array null");
        }
        for (int s = 0; s < string.length(); ++s) {
            char s_char = string.charAt(s);
            if (!TextTool.isOneOf((int)s_char, chars)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsOneOf(String string, IntegerRangeIndex chars) {
        int c;
        if (string == null || string.length() == 0) {
            return false;
        }
        if (chars == null) {
            throw new IllegalArgumentException("chars is null");
        }
        for (int i = 0; i < string.length(); i += Character.charCount(c)) {
            c = string.codePointAt(i);
            if (!TextTool.isOneOf(c, (IIntegerRangeIndex)chars)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsOnly(String string, char[] chars) {
        if (string == null || string.length() == 0) {
            return true;
        }
        if (chars == null || chars.length == 0) {
            throw new IllegalArgumentException("char array empty");
        }
        for (int s = 0; s < string.length(); ++s) {
            char s_char = string.charAt(s);
            if (TextTool.isOneOf((int)s_char, chars)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsOnly(String string, IIntegerRangeIndex legal) {
        int codePoint;
        if (string == null || string.length() == 0) {
            return true;
        }
        if (legal == null) {
            throw new IllegalArgumentException("char array empty");
        }
        for (int i = 0; i < string.length(); i += Character.charCount(codePoint)) {
            codePoint = string.codePointAt(i);
            if (legal.isInInterval(codePoint)) continue;
            return false;
        }
        return true;
    }

    public static int countConsecutiveMatches(String regex, String s) {
        String t = s;
        Pattern p = Pattern.compile("^(" + regex + ").*");
        int c = 0;
        Matcher m = p.matcher(t);
        while (m.matches()) {
            log.trace("match = '" + m.group(1) + "'");
            int l = m.group(1).length();
            ++c;
            t = t.substring(l);
            m = p.matcher(t);
        }
        return c;
    }

    public static int countNumberOfMarkerRepetitionsFromBeginOfString(String marker, String s) {
        int count = 0;
        for (int i = 0; i >= 0 && (i = s.indexOf(marker, i)) >= 0; i += marker.length()) {
            ++count;
        }
        return count;
    }

    public static boolean equalIgnoringTabooCharacters(String a, String b, IIntegerRangeIndex taboo, boolean caseMatters) {
        assert (a != null);
        assert (b != null);
        int aIndex = 0;
        int bIndex = 0;
        int aCodePoint = -1;
        int bCodePoint = -1;
        while (aIndex < a.length() && bIndex < b.length()) {
            while (aIndex < a.length()) {
                aCodePoint = a.codePointAt(aIndex);
                aIndex += Character.charCount(aCodePoint);
                if (!TextTool.isNoneOf(aCodePoint, taboo)) continue;
            }
            while (bIndex < b.length()) {
                bCodePoint = b.codePointAt(bIndex);
                bIndex += Character.charCount(bCodePoint);
                if (!TextTool.isNoneOf(bCodePoint, taboo)) continue;
            }
            if (TextTool.equals(aCodePoint, bCodePoint, caseMatters)) continue;
            return false;
        }
        while (aIndex < a.length()) {
            aCodePoint = a.codePointAt(aIndex);
            aIndex += Character.charCount(aCodePoint);
            if (!TextTool.isNoneOf(aCodePoint, taboo)) continue;
            return false;
        }
        while (bIndex < b.length()) {
            bCodePoint = b.codePointAt(bIndex);
            bIndex += Character.charCount(bCodePoint);
            if (!TextTool.isNoneOf(bCodePoint, taboo)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalNonWhitespaceCharacters(String a, String b, boolean caseMatters) {
        assert (a != null);
        assert (b != null);
        return TextTool.equalIgnoringTabooCharacters(a, b, (IIntegerRangeIndex)Unicodes.unicodePureSeparator, caseMatters);
    }

    public static boolean equals(int codePointA, int codePointB, boolean caseMatters) {
        if (caseMatters) {
            return codePointA == codePointB;
        }
        return Character.toLowerCase(codePointA) == Character.toLowerCase(codePointB);
    }

    public static boolean equals(String a, String b, boolean caseMatters) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (caseMatters) {
            return a.equals(b);
        }
        return a.equalsIgnoreCase(b);
    }

    public static String firstLetterUppercase(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1, s.length());
    }

    public static String foldLineBreaks(String s) {
        return s.replace("\n", "|\\n|");
    }

    public static String highlightPos(String s, int pos, int before, int after) {
        if (s == null) {
            return "(empty string)";
        }
        if (pos == -1) {
            int maxLen = before + 1 + after;
            return s.substring(0, Math.min(s.length(), maxLen));
        }
        if (s.length() < pos) {
            throw new IllegalArgumentException("String len " + s.length() + " <= pos " + pos);
        }
        int start = Math.max(pos - before, 0);
        int end = Math.min(pos + 1 + after, s.length());
        String pre = s.substring(start, pos);
        if (s.length() == pos) {
            return pre + MARKER_CLOSE + "END";
        }
        String highlight = s.substring(pos, pos + 1);
        String post = s.substring(pos + 1, end);
        return pre + MARKER_OPEN + highlight + MARKER_CLOSE + post;
    }

    public static String indent(int count, String indent) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            buf.append(indent);
        }
        return buf.toString();
    }

    public static boolean isNoneOf(int codePoint, char[] taboo) {
        assert (taboo != null);
        for (int i = 0; i < taboo.length; ++i) {
            if (codePoint != taboo[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isNoneOf(int codePoint, IIntegerRangeIndex taboo) {
        assert (taboo != null);
        return !taboo.isInInterval(codePoint);
    }

    public static boolean isOneOf(int codePoint, char[] legal) {
        assert (legal != null);
        for (int i = 0; i < legal.length; ++i) {
            if (codePoint != legal[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isOneOf(int codePoint, IIntegerRangeIndex legal) {
        assert (legal != null);
        return legal.isInInterval(codePoint);
    }

    public static boolean isOneOf(int codePoint, int[] legal) {
        assert (legal != null);
        for (int i = 0; i < legal.length; ++i) {
            if (codePoint != legal[i]) continue;
            return true;
        }
        return false;
    }

    public static String removeAllOf(String dirty, int ... taboo) {
        int c;
        if (taboo == null || taboo.length == 0) {
            return dirty;
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < dirty.length(); i += Character.charCount(c)) {
            c = dirty.codePointAt(i);
            if (TextTool.isOneOf(c, taboo)) continue;
            b.appendCodePoint(c);
        }
        return b.toString();
    }

    public static String removeAllOf(String dirty, IIntegerRangeIndex taboo, boolean invert) {
        int c;
        if (taboo == null || taboo.isEmpty()) {
            return dirty;
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < dirty.length(); i += Character.charCount(c)) {
            c = dirty.codePointAt(i);
            if (invert) {
                if (!TextTool.isOneOf(c, taboo)) continue;
                b.appendCodePoint(c);
                continue;
            }
            if (TextTool.isOneOf(c, taboo)) continue;
            b.appendCodePoint(c);
        }
        return b.toString();
    }

    public static StringBuilder join(Collection<String> coll, char sep, boolean escapeComponents) {
        if (coll.isEmpty()) {
            return new StringBuilder();
        }
        StringBuilder buf = new StringBuilder();
        Iterator<String> it = coll.iterator();
        String element = it.next();
        buf.append(escapeComponents ? TextTool.escape(element) : element);
        while (it.hasNext()) {
            buf.appendCodePoint(sep);
            element = it.next();
            buf.append(escapeComponents ? TextTool.escape(element) : element);
        }
        return buf;
    }

    public static StringBuilder joinStringBuilder(Collection<StringBuilder> coll, char sep) {
        if (coll.isEmpty()) {
            return new StringBuilder();
        }
        StringBuilder buf = new StringBuilder();
        Iterator<StringBuilder> it = coll.iterator();
        buf.append((CharSequence)it.next());
        while (it.hasNext()) {
            buf.appendCodePoint(sep);
            buf.append((CharSequence)it.next());
        }
        return buf;
    }

    public static String materializeEscapes(String raw) {
        assert (raw != null);
        return Escaping.materializeEscapes((String)raw, (boolean)false, (boolean)false);
    }

    public static String escape(String raw) {
        if (raw == null) {
            return null;
        }
        if (raw.length() == 0) {
            return "";
        }
        return Escaping.escape((String)raw, (boolean)false, (boolean)true);
    }

    public static String normalizeNewlines(String raw) {
        String s = raw;
        s = s.replace("\r\n", "\n");
        s = s.replace("\r", "\n");
        return s;
    }

    public static String padLeft(String padding, String s, int desiredTotalLength) {
        if (s.length() >= desiredTotalLength) {
            return s;
        }
        int missing = desiredTotalLength - s.length();
        int adding = missing / padding.length();
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < adding; ++i) {
            buf.append(padding);
        }
        buf.append(s);
        return buf.toString();
    }

    public static String padRight(String padding, String s, int desiredTotalLength) {
        if (s.length() >= desiredTotalLength) {
            return s;
        }
        int missing = desiredTotalLength - s.length();
        int adding = missing / padding.length();
        StringBuilder buf = new StringBuilder();
        buf.append(s);
        for (int i = 0; i < adding; ++i) {
            buf.append(padding);
        }
        return buf.toString();
    }

    public static String[] split(String s, String separators, boolean stripQuotes) {
        int codepoint;
        assert (!separators.contains("'")) : "reserved for string-delimiting";
        assert (!separators.contains("\"")) : "reserved for string-delimiting";
        assert (!separators.contains("\\")) : "reserved for escape-processing";
        ArrayList<String> tokenList = new ArrayList<String>();
        StringBuilder currentToken = new StringBuilder();
        int lastQuote = -1;
        for (int index = 0; index < s.length(); index += Character.charCount(codepoint)) {
            codepoint = s.codePointAt(index);
            if (codepoint == 92) {
                currentToken.appendCodePoint(codepoint);
                if (index + 1 >= s.length()) continue;
                currentToken.appendCodePoint(s.codePointAt(index + 1));
                ++index;
                continue;
            }
            if (lastQuote == -1) {
                if (TextTool.codepointIsOneOf(codepoint, separators)) {
                    if (currentToken.length() > 0) {
                        tokenList.add(TextTool.trim(currentToken.toString()));
                    }
                    currentToken = new StringBuilder();
                    lastQuote = -1;
                    continue;
                }
                if (codepoint == 39 || codepoint == 34) {
                    lastQuote = codepoint;
                    if (stripQuotes) continue;
                    currentToken.appendCodePoint(codepoint);
                    continue;
                }
                currentToken.appendCodePoint(codepoint);
                continue;
            }
            if (codepoint == lastQuote) {
                if (!stripQuotes) {
                    currentToken.appendCodePoint(codepoint);
                }
                lastQuote = -1;
                continue;
            }
            currentToken.appendCodePoint(codepoint);
        }
        if (currentToken.length() > 0) {
            tokenList.add(TextTool.trim(currentToken.toString()));
        }
        return tokenList.toArray(new String[tokenList.size()]);
    }

    public static boolean startsWith(String s, String prefix, boolean caseMatters) {
        assert (s != null);
        assert (prefix != null);
        if (caseMatters) {
            return s.startsWith(prefix);
        }
        return s.toLowerCase().startsWith(prefix.toLowerCase());
    }

    public static String substring(String str, int start, int end) {
        assert (str != null);
        assert (start >= 0);
        assert (start <= str.length());
        assert (end == -1 || end >= 0 && end <= str.length());
        if (end == -1) {
            return str.substring(start);
        }
        return str.substring(start, end);
    }

    public static String toLimitedString(Object object, int maxLen) {
        return DebugUtils.toLimitedString((Object)object, (int)maxLen);
    }

    public static String toMergedUpperCase(String a, String b) {
        int ac;
        if (a == null) {
            throw new IllegalArgumentException();
        }
        if (b == null) {
            throw new IllegalArgumentException();
        }
        if (a.length() != b.length()) {
            throw new IllegalArgumentException("a='" + a + "' b='" + b + "'");
        }
        if (!a.equalsIgnoreCase(b)) {
            throw new IllegalArgumentException("a='" + a + "' b='" + b + "'");
        }
        StringBuilder res = new StringBuilder();
        for (int r = 0; r < a.length(); r += Character.charCount(ac)) {
            ac = a.codePointAt(r);
            if (Character.isUpperCase(ac)) {
                res.appendCodePoint(ac);
                continue;
            }
            res.appendCodePoint(b.codePointAt(r));
        }
        return res.toString();
    }

    public static String trim(String s) {
        assert (s != null);
        if (s.length() == 0) {
            return s;
        }
        int i = 0;
        boolean searching = true;
        while (i < s.length() && searching) {
            int c = s.codePointAt(i);
            if (TextTool.isWhitespace(c)) {
                i += Character.charCount(i);
                continue;
            }
            searching = false;
        }
        if (i == s.length()) {
            return "";
        }
        int startInclusive = i;
        i = s.length() - 1;
        searching = true;
        while (i >= startInclusive && searching) {
            int c = s.codePointAt(i);
            if (!Character.isValidCodePoint(c)) {
                --i;
            }
            if (TextTool.isWhitespace(c)) {
                --i;
                continue;
            }
            searching = false;
        }
        if (!Character.isValidCodePoint(s.codePointAt(i))) {
            --i;
        }
        int endInclusive = i;
        assert (startInclusive <= endInclusive) : "failed for '" + s + "' start=" + startInclusive + " end=" + endInclusive;
        return s.substring(startInclusive, endInclusive + 1);
    }

    public static boolean isWhitespace(int c) {
        switch (c) {
            case 9: 
            case 10: 
            case 13: 
            case 32: 
            case 160: {
                return true;
            }
        }
        return false;
    }

    public static String urlEncode(String raw) {
        return URLUtils.encode((String)raw);
    }

    public static String urlDecode(String enc) {
        return URLUtils.decode((String)enc);
    }

    public static String interpolate(String raw, final Map<String, String> simpleMap) {
        return TextTool.interpolate(raw, new IReplacements(){

            @Override
            public String getReplacement(String varName) {
                return (String)simpleMap.get(varName);
            }
        });
    }

    public static String interpolate(String raw, IReplacements replacements) {
        if (raw == null) {
            return null;
        }
        String done = raw;
        Matcher m = REGEX_VAR_PATTERN.matcher(done);
        int replacedVariables = 0;
        while (m.matches()) {
            String varString = m.group(1);
            String varName = m.group(2) == null ? m.group(3) : m.group(2);
            String replacement = replacements.getReplacement(varName);
            if (replacement == null) {
                log.warn("Could not interpolate " + varString);
                break;
            }
            log.trace("Replacing '" + varName + "' with '" + replacement + "'");
            done = done.replace(varString, replacement);
            m = REGEX_VAR_PATTERN.matcher(done);
            ++replacedVariables;
        }
        log.debug("Replaced " + replacedVariables);
        return done;
    }

    public static String lastPartSeparatedBy(String s, String separator) {
        int i = s.lastIndexOf(separator);
        if (i < 0 || i + separator.length() > s.length()) {
            return null;
        }
        return s.substring(i + separator.length());
    }

    public static String wrap(String s, int maxLineLenght) {
        return TextTool.wrap(s, maxLineLenght, "\n", false);
    }

    @LicenseApache(project="Apache Commons Lang", copyright="Copyright 2001-2011 The Apache Software Foundation")
    public static String wrap(String str, int wrapLength, String newLineStr, boolean wrapLongWords) {
        if (str == null) {
            return null;
        }
        assert (newLineStr != null);
        assert (wrapLength >= 1);
        int inputLineLength = str.length();
        int offset = 0;
        StringBuilder wrappedLine = new StringBuilder(inputLineLength + 32);
        while (inputLineLength - offset > wrapLength) {
            if (str.charAt(offset) == ' ') {
                ++offset;
                continue;
            }
            int spaceToWrapAt = str.lastIndexOf(32, wrapLength + offset);
            if (spaceToWrapAt >= offset) {
                wrappedLine.append(str.substring(offset, spaceToWrapAt));
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            if (wrapLongWords) {
                wrappedLine.append(str.substring(offset, wrapLength + offset));
                wrappedLine.append(newLineStr);
                offset += wrapLength;
                continue;
            }
            spaceToWrapAt = str.indexOf(32, wrapLength + offset);
            if (spaceToWrapAt >= 0) {
                wrappedLine.append(str.substring(offset, spaceToWrapAt));
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            wrappedLine.append(str.substring(offset));
            offset = inputLineLength;
        }
        wrappedLine.append(str.substring(offset));
        return wrappedLine.toString();
    }

    public static String toTitleCase(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    public static int compare(String a, String b, boolean caseMatters) {
        if (caseMatters) {
            return a.compareTo(b);
        }
        int c = a.toLowerCase().compareTo(b.toLowerCase());
        if (c == 0) {
            return a.compareTo(b);
        }
        return c;
    }

    public static void sort(List<String> stringList, final boolean caseMatters) {
        Collections.sort(stringList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return TextTool.compare(o1, o2, caseMatters);
            }
        });
    }

    public static int countLegalCharacters(String source, int start, int endExclusive, IIntegerRangeIndex legal) {
        int c;
        int count = 0;
        for (int i = start; i < endExclusive; i += Character.charCount(c)) {
            c = source.codePointAt(i);
            if (!legal.isInInterval(c)) continue;
            count += Character.charCount(c);
        }
        return count;
    }

    public static boolean equals(Set<String> a, Set<String> b, boolean caseMatters) {
        if (!caseMatters) {
            return a.equals(b);
        }
        if (a.size() != b.size()) {
            return false;
        }
        HashSet<String> aLowercase = new HashSet<String>(a.size());
        for (String s : a) {
            aLowercase.add(s.toLowerCase());
        }
        for (String bString : b) {
            if (aLowercase.contains(bString.toLowerCase())) continue;
            return false;
        }
        return true;
    }

    public static String lowercase(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        return s.toLowerCase();
    }

    public static String removeIllegalOrDiscouragedXml10Characters(String contentString) {
        return TextTool.removeAllOf(contentString, (IIntegerRangeIndex)Unicodes.legalEncouragedXml10, true);
    }

    public static boolean isUpperCase(String s) {
        return TextTool.containsOnly(s, (IIntegerRangeIndex)Unicodes.unicodeUpperCase);
    }

    public static boolean isLowerCase(String s) {
        return TextTool.containsOnly(s, (IIntegerRangeIndex)Unicodes.unicodeLowerCase);
    }

    public static String toLowercasedEmail(String email) {
        int i = email.indexOf(64);
        assert (i > 0) : "found not @-sign in email address '" + email + "'";
        String localPart = email.substring(0, i);
        String hostPart = email.substring(i + 1);
        return localPart + "@" + hostPart.toLowerCase();
    }

    public static String toLowercasedURI(URI uri) {
        String uriString = uri.toString();
        String host = uri.getHost();
        if (host == null) {
            log.warn("A valid URL without host: '" + uri + "'");
        } else {
            int i = uriString.indexOf(host);
            uriString = uriString.substring(0, i) + host.toLowerCase() + uriString.substring(i + host.length());
        }
        return uriString;
    }

    public static Comparator<String> createComparator(final boolean caseMatters) {
        return new Comparator<String>(){

            @Override
            public int compare(String a, String b) {
                return TextTool.compare(a, b, caseMatters);
            }
        };
    }

    public static interface IReplacements {
        public String getReplacement(String var1);
    }
}

