/*
 * Decompiled with CFR 0.152.
 */
package de.xam.texthtml.text;

import de.xam.texthtml.html.SharedHtmlUtils;
import de.xam.texthtml.text.TextRenderer;
import de.xam.texthtml.text.TextTool;
import org.xydra.annotations.Template;
import org.xydra.base.id.XidCodec;
import org.xydra.core.serialize.json.JsonEncoder;

public class EncTool {
    private static final String XSS_INFO_URL = "http://en.wikipedia.org/wiki/Cross-site_scripting";
    private static EncTool instance;
    public static final char[] FILENAME_CRITICAL;
    private static final char[] hexArray;

    @Template(value="Exposed as $enc.htmlText(..)")
    public static String htmlText(String s) {
        return SharedHtmlUtils.sanitize(s);
    }

    public static String htmlHref(String unsafeHref) {
        String lower = unsafeHref.toLowerCase();
        if (lower.startsWith("http:") || lower.startsWith("https:") || lower.startsWith("mailto:")) {
            return unsafeHref;
        }
        return XSS_INFO_URL;
    }

    public static synchronized EncTool getInstance() {
        if (instance == null) {
            instance = new EncTool();
        }
        return instance;
    }

    public static String jsonString(String unsafe) {
        return JsonEncoder.encode((String)unsafe);
    }

    public static String jsonInHtml(String unsafe) {
        String html = EncTool.htmlText(unsafe);
        return JsonEncoder.encode((String)html);
    }

    public static String htmlTextAutolinkUrls(String unsafePlaintext) {
        return TextRenderer.renderAsSafeHtml(unsafePlaintext);
    }

    public static String escapeCssIdOrClassname(String raw) {
        int c;
        assert (raw != null);
        StringBuilder esc = new StringBuilder();
        for (int i = 0; i < raw.length(); i += Character.charCount(c)) {
            c = raw.codePointAt(i);
            if (c == 45 || c == 95 || c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57) {
                esc.appendCodePoint(c);
                continue;
            }
            esc.append('\\');
            esc.append(Integer.toHexString(c));
            esc.append(" ");
        }
        return esc.toString();
    }

    public static String escapeFilename(String name) {
        int codePoint;
        StringBuilder enc = new StringBuilder();
        for (int i = 0; i < name.length(); i += Character.charCount(codePoint)) {
            codePoint = name.codePointAt(i);
            if (codePoint == 37 || TextTool.isOneOf(codePoint, FILENAME_CRITICAL)) {
                XidCodec.appendEncoded((StringBuilder)enc, (int)37, (int)codePoint, (int)200);
                continue;
            }
            enc.appendCodePoint(codePoint);
        }
        return enc.toString();
    }

    public static String unescapeFilename(String filename) {
        return XidCodec.decode((String)filename, (int)37);
    }

    public static String bytesToHex(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    static {
        FILENAME_CRITICAL = new char[]{'/', '\\', '?', '%', '*', ':', '|', '\"', '<', '>', ' '};
        hexArray = "0123456789ABCDEF".toCharArray();
    }
}

