/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.gwt;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.webapp.WebAppContext;
import org.xydra.gwt.TestServer;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.log.coreimpl.sysout.DefaultLoggerFactorySPI;
import org.xydra.log.spi.ILoggerFactorySPI;

public class GwtTestServer {
    private static Logger log = GwtTestServer.getLogger();
    private final int port;
    private Server server;
    private WebAppContext webapp;

    private static Logger getLogger() {
        LoggerFactory.setLoggerFactorySPI((ILoggerFactorySPI)new DefaultLoggerFactorySPI(), (String)"GwtTestServer");
        return LoggerFactory.getLogger(GwtTestServer.class);
    }

    public GwtTestServer() {
        this(8888);
    }

    public GwtTestServer(int port) {
        this.port = port;
    }

    private URI startServer() throws Exception {
        this.server = new Server(this.port);
        String contextPath = "/";
        File docRoot = new File("target/gwt-0.1.4-SNAPSHOT");
        File webappRoot = new File("src/main/webapp");
        this.webapp = new WebAppContext(webappRoot.getAbsolutePath(), "/");
        this.webapp.setClassLoader(Thread.currentThread().getContextClassLoader());
        HandlerList hl = new HandlerList();
        ResourceHandler publicDocs = new ResourceHandler(){};
        publicDocs.setResourceBase(webappRoot.getAbsolutePath());
        hl.addHandler((Handler)publicDocs);
        ResourceHandler gwtFiles = new ResourceHandler(){};
        gwtFiles.setResourceBase(docRoot.getAbsolutePath());
        hl.addHandler((Handler)gwtFiles);
        this.webapp.setHandler((Handler)hl);
        FilterHolder filterHolder = new FilterHolder();
        filterHolder.setFilter(new Filter(){

            public void destroy() {
            }

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
                System.out.println("Jetty GET " + ((HttpServletRequest)request).getRequestURI());
                HttpServletResponseWrapper responseWrapper = new HttpServletResponseWrapper((HttpServletResponse)response);
                Calendar cal = Calendar.getInstance();
                cal.set(1, cal.get(1) + 1);
                SimpleDateFormat dateFormatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
                TimeZone tz = TimeZone.getTimeZone("GMT");
                dateFormatter.setTimeZone(tz);
                String rfc1123 = dateFormatter.format(cal.getTime());
                ((HttpServletResponse)response).addHeader("Expires", rfc1123);
                ((HttpServletResponse)response).addHeader("Cache-Control", "public; max-age=31536000");
                filterChain.doFilter(request, (ServletResponse)responseWrapper);
            }

            public void init(FilterConfig filterConfig) {
            }
        });
        this.webapp.addFilter(filterHolder, "*.png", EnumSet.allOf(DispatcherType.class));
        this.webapp.addFilter(filterHolder, "*.gif", EnumSet.allOf(DispatcherType.class));
        this.webapp.addFilter(filterHolder, ".cache.*", EnumSet.allOf(DispatcherType.class));
        this.server.setHandler((Handler)this.webapp);
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            URI uri = new URI("http://localhost:" + this.port + "/");
            if (!"/".equals("") && !"/".equals("/")) {
                uri = uri.resolve("//");
            }
            return uri;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        TestServer testServer = new TestServer();
        URI store = testServer.startXydraServer(new File("src/test/resources/webapp"));
        URI ui = new GwtTestServer().startServer();
        log.info("Started servers.");
        log.info(" - Backend is at " + store);
        log.info(" - User interface is at " + ui + "XydraEditor.html");
    }
}

