/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tokenpipe.user.pipe.link;

import de.xam.texthtml.text.AnnotatedString;
import de.xam.tokenpipe.IToken;
import de.xam.tokenpipe.ITokenPipe;
import de.xam.tokenpipe.ITokenStream;
import de.xam.tokenpipe.Token;
import de.xam.tokenpipe.pipe.AbstractTokenPipe;
import de.xam.tokenpipe.user.pipe.link.Autolinker;
import de.xam.tokenpipe.user.pipe.link.LinkInfo;
import de.xam.tokenpipe.user.pipe.link.LinkTool;
import de.xam.tokenpipe.user.pipe.link.LinkType;
import de.xam.tokenpipe.user.pipe.link.ManualLinkFinder;
import de.xam.tokenpipe.user.pipe.link.spi.IAutoLinkSearchEngine;
import de.xam.tokenpipe.user.pipe.link.spi.ILinkListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xydra.base.XId;
import org.xydra.index.impl.IntegerRangeIndex;
import org.xydra.index.query.Pair;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class LinkPipe
extends AbstractTokenPipe
implements ITokenPipe {
    private static final Logger log = LoggerFactory.getLogger(LinkPipe.class);
    private final IAutoLinkSearchEngine<LinkInfo, XId> autolinkSearchEngine;
    private boolean createManualLinks = true;
    private boolean findAutoLinks = true;
    private ILinkListener linkListener;

    public LinkPipe(ILinkListener linkListener, IAutoLinkSearchEngine<LinkInfo, XId> autolinkSearchEngine) {
        this.linkListener = linkListener;
        this.autolinkSearchEngine = autolinkSearchEngine;
    }

    public String[] consumedTokenTypes() {
        return new String[]{"inline"};
    }

    public String getLabel() {
        return "link";
    }

    public boolean isCreateManualLinks() {
        return this.createManualLinks;
    }

    public boolean isFindAutoLinks() {
        return this.findAutoLinks;
    }

    public void onFullUrl(int leadingWhitespaceStart, int fullUrlStart, int trailingWhitespaceEnd, int matchEnd) {
    }

    public void onToken(ITokenStream stream, IToken token) {
        Iterator spanIt;
        assert (token.getType().equals("inline"));
        assert (token.isContent());
        String content = token.getChars();
        AnnotatedString annotatedContent = new AnnotatedString(content);
        ManualLinkFinder manualLinkFinder = new ManualLinkFinder();
        manualLinkFinder.findLinks((AnnotatedString<LinkInfo>)annotatedContent);
        if (this.findAutoLinks) {
            assert (this.autolinkSearchEngine != null);
            ArrayList<AnnotatedString.AnnotatedSpan<LinkInfo>> autolinks = new ArrayList<AnnotatedString.AnnotatedSpan<LinkInfo>>();
            spanIt = annotatedContent.spanIterator(content.length() - 1);
            while (spanIt.hasNext()) {
                IntegerRangeIndex.Span span = (IntegerRangeIndex.Span)spanIt.next();
                if (span.isInRange()) continue;
                if (log.isTraceEnabled()) {
                    log.trace("Finding auto-links in '" + annotatedContent.getString(span) + "'");
                }
                List<AnnotatedString.AnnotatedSpan<LinkInfo>> list = Autolinker.findAutolinkMatches((AnnotatedString<LinkInfo>)annotatedContent, span, this.autolinkSearchEngine);
                autolinks.addAll(list);
            }
            for (AnnotatedString.AnnotatedSpan annotatedSpan : autolinks) {
                annotatedContent.addAnnotation(annotatedSpan);
            }
        }
        boolean turnUriIntoItems = false;
        spanIt = annotatedContent.spanIterator(content.length() - 1);
        boolean firstInlineToken = token.getContextAsMap().containsKey("inline-first-child");
        while (spanIt.hasNext()) {
            IntegerRangeIndex.Span span = (IntegerRangeIndex.Span)spanIt.next();
            if (span.isInRange()) {
                AnnotatedString.AnnotatedSpan annSpan = annotatedContent.getAnnotationStartingAt(span.getStartInclusive());
                LinkInfo linkInfo = (LinkInfo)annSpan.getAnnotation();
                linkInfo.setLinkText(annotatedContent.getString(annSpan));
                LinkType linkType = linkInfo.getLinkType();
                assert (linkInfo != null);
                assert (linkType != null);
                assert (linkInfo.getLinkText() != null);
                if (!this.createManualLinks && linkType != LinkType.AutoWikiLink) continue;
                switch (linkType) {
                    case FullUrl: 
                    case PartialUrlWithoutScheme: 
                    case FullEmail: {
                        LinkTool.fireLink(stream, linkInfo, false, this.linkListener, stream.getParseContext());
                        break;
                    }
                    case CamelCaseWikiLink: 
                    case ForcedBracedWikiLink: {
                        if (linkInfo.isValid()) {
                            LinkTool.fireLink(stream, linkInfo, true, this.linkListener, stream.getParseContext());
                            break;
                        }
                        log.warn("Invalid link '" + linkInfo.getLinkText() + " | " + linkInfo.getLinkTargetName() + "' due to " + linkInfo.getProblem() + " at " + stream.getParseContext());
                        break;
                    }
                    case AutoWikiLink: {
                        linkInfo.setLinkCause(ILinkListener.LinkCause.autolink);
                        LinkTool.fireLink(stream, linkInfo, true, this.linkListener, stream.getParseContext());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("not yet impl");
                    }
                }
                continue;
            }
            String tokenContent = content.substring(span.getStartInclusive(), span.getEndInclusive() + 1);
            Token inlineToken = Token.create((IToken.Kind)IToken.Kind.Content, (String)"inline", (String)tokenContent, (Pair[])new Pair[0]);
            if (firstInlineToken) {
                inlineToken.getContextAsMap().put("inline-first-child", "true");
                firstInlineToken = false;
            }
            stream.fireToken((IToken)inlineToken);
        }
    }

    public String[] producedTokenTypes() {
        return new String[]{"inline", "link"};
    }

    public void setCreateManualLinks(boolean createManualLinks) {
        this.createManualLinks = createManualLinks;
    }

    public void setFindAutoLinks(boolean findAutoLinks) {
        this.findAutoLinks = findAutoLinks;
    }

    public void setItemLinkListener(ILinkListener linkListener) {
        this.linkListener = linkListener;
    }
}

