/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tokenpipe.user.pipe.link;

import de.xam.texthtml.text.AnnotatedString;
import de.xam.tokenpipe.user.pipe.link.LinkInfo;
import de.xam.tokenpipe.user.pipe.link.LinkType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xydra.index.impl.IntegerRangeIndex;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class LinkFinders {
    private static final Logger log = LoggerFactory.getLogger(LinkFinders.class);

    public static void findAndIndexNonOverlappingMatches(Pattern findPattern, LinkType linkType, AnnotatedString<LinkInfo> annotatedContent) {
        for (IntegerRangeIndex.Span span : annotatedContent.spansNotInRangeList()) {
            String spanContent = annotatedContent.getString(span);
            Matcher matcher = findPattern.matcher(spanContent);
            matcher.useTransparentBounds(true);
            while (matcher.find()) {
                int end;
                int start = matcher.start(2);
                if (start >= 0) {
                    end = matcher.end(2);
                } else {
                    start = matcher.start(5);
                    end = matcher.end(5);
                }
                end += span.getStartInclusive();
                assert ((start += span.getStartInclusive()) >= 0);
                assert (end >= 0);
                assert (start <= end) : "start=" + start + " end=" + end;
                assert (!annotatedContent.isAnnotated(start));
                if (log.isTraceEnabled()) {
                    log.trace("Found manual link: '" + annotatedContent.getString().substring(start, end) + "' of type " + (Object)((Object)linkType));
                }
                annotatedContent.addAnnotation(start, end - 1, (Object)new LinkInfo(linkType));
            }
        }
    }
}

