/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tokenpipe.user.pipe;

import de.xam.texthtml.text.TextTool;
import de.xam.tokenpipe.IToken;
import de.xam.tokenpipe.ITokenStream;
import de.xam.tokenpipe.pipe.AbstractTokenPipe;
import de.xam.tokenpipe.pipe.buffer.LookBackBuffer;
import de.xam.tokenpipe.pipe.buffer.TokenBuffer;
import org.xydra.index.query.Pair;

public class EscapeTokenPipe
extends AbstractTokenPipe {
    private LookBackBuffer buffer;

    public String getLabel() {
        return "escape";
    }

    public String[] consumedTokenTypes() {
        return new String[]{"document", "chunk", "string", "pre"};
    }

    public String[] producedTokenTypes() {
        return new String[]{"document", "chunk", "inline", "string", "pre"};
    }

    public void onBeforeDocument() {
        this.buffer = new LookBackBuffer(this.getLabel(), new TokenBuffer(this.getLabel()));
    }

    public void onToken(ITokenStream stream, IToken token) {
        switch (token.getKind()) {
            case Content: {
                String s = token.getChars();
                assert (s != null) : "" + token;
                s = TextTool.materializeEscapes((String)s);
                s = TextTool.normalizeNewlines((String)s);
                this.buffer.continueCurrentToken(s);
                this.buffer.fireCurrentContentToBuffer(token.getType(), token.getContextAsPairsAndAdd(new Pair[0]));
                this.buffer.flushTokenBufferAndFireTokens(stream);
                break;
            }
            case Start: {
                stream.fireToken(token);
                this.buffer.flushTokenBufferAndFireTokens(stream);
                break;
            }
            case End: {
                this.buffer.flushTokenBufferAndFireTokens(stream);
                stream.fireToken(token);
            }
        }
    }
}

