/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tokenpipe.user.pipe;

import de.xam.tokenpipe.IToken;
import de.xam.tokenpipe.ITokenPipe;
import de.xam.tokenpipe.ITokenStream;
import de.xam.tokenpipe.pipe.AbstractTokenPipe;
import de.xam.tokenpipe.pipe.buffer.LookBackBuffer;
import de.xam.tokenpipe.pipe.buffer.TokenBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;
import org.xydra.index.query.Pair;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class EmphTokenPipe2
extends AbstractTokenPipe
implements ITokenPipe {
    private static final Logger log = LoggerFactory.getLogger(EmphTokenPipe2.class);
    private static final int CHAR_STAR = 42;
    private static final int CHAR_UNDERSCORE = 95;
    private int currentEmphLevel;
    private Stack<Integer> emphTokens;
    private LookBackBuffer lookBackBuffer;
    private int markerCount;

    public String getLabel() {
        return "emph";
    }

    public String[] consumedTokenTypes() {
        return new String[]{"inline"};
    }

    public String[] producedTokenTypes() {
        return new String[]{"inline", "emph"};
    }

    public void onBeforeDocument() {
        this.markerCount = 0;
        this.currentEmphLevel = 0;
        this.emphTokens = new Stack();
        this.lookBackBuffer = new LookBackBuffer(this.getLabel(), new TokenBuffer(this.getLabel()));
    }

    public void onAfterContentToken(ITokenStream stream, IToken token) {
        assert (token.getType().equals("inline"));
        this.maybeFireEmphTokensToBuffer(false);
        if (this.currentEmphLevel > 0) {
            this.lookBackBuffer.giveUpTokensAndTreatAsContent();
            this.emphTokens.clear();
            this.currentEmphLevel = 0;
        }
        this.lookBackBuffer.fireCurrentContentToBuffer("inline", EmphTokenPipe2.atts(this.currentEmphLevel, 0));
        this.lookBackBuffer.flushTokenBufferAndFireTokens(stream);
    }

    public void onContentCodepoint(ITokenStream stream, int c, int i, IToken token) {
        if (c == 42 || c == 95) {
            this.lookBackBuffer.lookBack(c);
            ++this.markerCount;
        } else {
            this.maybeFireEmphTokensToBuffer(token.getContextAsMap().containsKey("inline-first-child"));
            this.lookBackBuffer.continueCurrentToken(c);
        }
    }

    private void maybeFireEmphTokensToBuffer(boolean parsingFirstInlineTokenOfALine) {
        if (this.markerCount == 0) {
            return;
        }
        assert (this.markerCount > 0);
        if (parsingFirstInlineTokenOfALine) {
            Pair<String, String>[] pairs = EmphTokenPipe2.atts(this.currentEmphLevel, 0);
            ArrayList<Object> list = new ArrayList<Object>();
            list.addAll(Arrays.asList(pairs));
            list.add(new Pair((Object)"inline-first-child", (Object)"true"));
            pairs = list.toArray(new Pair[list.size()]);
            this.lookBackBuffer.fireCurrentContentToBuffer("inline", pairs);
        } else {
            this.lookBackBuffer.fireCurrentContentToBuffer("inline", EmphTokenPipe2.atts(this.currentEmphLevel, 0));
        }
        if (!this.emphTokens.isEmpty() && this.emphTokens.peek() == this.markerCount) {
            assert (this.currentEmphLevel >= this.markerCount);
            this.emphTokens.pop();
            this.lookBackBuffer.fireLookBackAsEndToBuffer("emph", EmphTokenPipe2.atts(this.currentEmphLevel, -this.markerCount));
            this.currentEmphLevel -= this.markerCount;
        } else if (this.currentEmphLevel + this.markerCount <= 3) {
            this.emphTokens.push(this.markerCount);
            this.currentEmphLevel += this.markerCount;
            this.lookBackBuffer.fireLookBackAsStartToBuffer("emph", EmphTokenPipe2.atts(this.currentEmphLevel, this.markerCount));
        } else {
            this.lookBackBuffer.giveUpTokensAndTreatAsContent();
            this.emphTokens.clear();
            this.currentEmphLevel = 0;
            if (this.markerCount > 3) {
                this.lookBackBuffer.flushLookback();
                this.markerCount = 0;
            } else {
                assert (this.currentEmphLevel + this.markerCount <= 3);
                this.maybeFireEmphTokensToBuffer(false);
            }
        }
        this.markerCount = 0;
    }

    private static Pair<String, String>[] atts(int emphLevel, int emphDelta) {
        assert (emphLevel >= 0) : "emphLevel=" + emphLevel;
        assert (emphLevel <= 3) : "emphLevel=" + emphLevel;
        return new Pair[]{new Pair((Object)"emphLevel", (Object)("" + emphLevel)), new Pair((Object)"emphDelta", (Object)("" + emphDelta))};
    }
}

