/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tokenpipe.user.pipe;

import de.xam.tokenpipe.IToken;
import de.xam.tokenpipe.ITokenPipe;
import de.xam.tokenpipe.ITokenStream;
import de.xam.tokenpipe.user.pipe.TokenDefs;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class DebugTokenPipe
implements ITokenPipe {
    private static final Logger log = LoggerFactory.getLogger(DebugTokenPipe.class);

    public String[] producedTokenTypes() {
        return TokenDefs.VALUES();
    }

    public String[] consumedTokenTypes() {
        return TokenDefs.VALUES();
    }

    public String getLabel() {
        return "DEBUG";
    }

    public void onBeforeContentToken(ITokenStream stream, IToken token) {
        log.info("BEFORE CONTENT TOKEN " + token.toString(100, false));
    }

    public void onAfterContentToken(ITokenStream stream, IToken token) {
        log.info("AFTER CONTENT TOKEN " + token.toString(100, false));
    }

    public void onToken(ITokenStream stream, IToken token) {
        log.info("ON TOKEN " + token.toString(100, false));
        stream.fireToken(token);
    }

    public void onContentCodepoint(ITokenStream stream, int codepoint, int pos, IToken token) {
    }

    public void onBeforeDocument() {
        log.info("BEFORE DOCUMENT");
    }

    public void onAfterDocument() {
        log.info("AFTER DOCUMENT");
    }

    public void onException(Throwable e) {
        log.info("EXCEPTION", e);
    }
}

