/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.runtime.instrumentation.common.com.google.common.base;

import com.google.monitoring.runtime.instrumentation.common.com.google.common.annotations.Beta;
import com.google.monitoring.runtime.instrumentation.common.com.google.common.base.Equivalence;
import com.google.monitoring.runtime.instrumentation.common.com.google.common.base.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class Equivalences {
    private Equivalences() {
    }

    public static Equivalence<Object> equals() {
        return Impl.EQUALS;
    }

    public static Equivalence<Object> nullAwareEquals() {
        return Impl.NULL_AWARE_EQUALS;
    }

    public static Equivalence<Object> identity() {
        return Impl.IDENTITY;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Impl implements Equivalence<Object>
    {
        EQUALS{

            public boolean equivalent(Object a, Object b) {
                return a.equals(b);
            }

            public int hash(Object o) {
                return o.hashCode();
            }
        }
        ,
        IDENTITY{

            public boolean equivalent(Object a, Object b) {
                return a == b;
            }

            public int hash(Object o) {
                return System.identityHashCode(o);
            }
        }
        ,
        NULL_AWARE_EQUALS{

            public boolean equivalent(Object a, Object b) {
                return Objects.equal(a, b);
            }

            public int hash(Object o) {
                return o.hashCode();
            }
        };

    }
}

