/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.csv.impl.memory;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class CsvCodec {
    public static final byte[] BOM_UTF8 = new byte[]{-17, -69, -65};
    public static final byte[] BOM_UTF16LE = new byte[]{-1, -2, 0, 0};
    public static final String CELL_DELIMITER = ";";

    public static String excelDecode(String encoded) {
        if (encoded.equals("") || encoded.equals("\"\"") || encoded.equals("=\"\"")) {
            return null;
        }
        String decoded = encoded;
        if (decoded.startsWith("=")) {
            decoded = decoded.substring(1);
        }
        if (decoded.startsWith("\"") && decoded.endsWith("\"")) {
            decoded = decoded.substring(1, decoded.length() - 1);
        }
        decoded = decoded.replace("\"\"", "\"");
        return decoded;
    }

    public static String excelEncode(String value) {
        if (value == null || value.equals("null")) {
            return "\"\"";
        }
        String escaped = value.contains("\"") ? value.replace("\"", "\"\"") : value;
        escaped = escaped.replace("\n", "\u00a7N");
        escaped = escaped.replace("\r", "\u00a7R");
        return "\"" + escaped + "\"";
    }

    public static String[] splitAtUnquotedSemicolon(String line) {
        boolean inQuote = false;
        LinkedList<String> result = new LinkedList<String>();
        StringBuffer currentString = new StringBuffer();
        block4: for (int index = 0; index < line.length(); ++index) {
            char c = line.charAt(index);
            switch (c) {
                case '\"': {
                    inQuote = !inQuote;
                    currentString.append(c);
                    continue block4;
                }
                case '\t': 
                case ';': {
                    if (inQuote) {
                        currentString.append(c);
                        continue block4;
                    }
                    result.add(currentString.toString());
                    currentString = new StringBuffer();
                    continue block4;
                }
                default: {
                    currentString.append(c);
                }
            }
        }
        result.add(currentString.toString());
        return result.toArray(new String[result.size()]);
    }

    public static List<String> excelDecodeRow(String line) {
        if (line == null) {
            return Collections.emptyList();
        }
        assert (line != null);
        LinkedList<String> row = new LinkedList<String>();
        String[] datas = CsvCodec.splitAtUnquotedSemicolon(line);
        for (int i = 0; i < datas.length; ++i) {
            String value = CsvCodec.excelDecode(datas[i]);
            row.add(value);
        }
        return row;
    }

    public static String excelEncodeRow(List<String> values) {
        if (values == null) {
            return "";
        }
        assert (values != null);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.size(); ++i) {
            sb.append(CsvCodec.excelEncode(values.get(i)));
            if (i + 1 >= values.size()) continue;
            sb.append(CELL_DELIMITER);
        }
        return sb.toString();
    }
}

