/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.csv.impl.memory;

import org.xydra.csv.ICell;
import org.xydra.csv.TypeHandler;
import org.xydra.csv.WrongDatatypeException;

class Cell
implements ICell {
    private String value;

    public Cell() {
    }

    public Cell(String string) {
        this.value = string;
    }

    @Override
    public void appendString(String s, int maximalFieldLength) {
        int sLen;
        int n = sLen = this.value == null ? 0 : this.value.length();
        if (sLen < maximalFieldLength) {
            if (this.value == null) {
                this.value = "";
            }
            this.value = this.value + s.substring(0, Math.min(s.length(), maximalFieldLength - sLen));
        }
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public double getValueAsDouble() throws WrongDatatypeException {
        return TypeHandler.asDouble(this.value);
    }

    @Override
    public long getValueAsLong() throws WrongDatatypeException {
        return TypeHandler.asLong(this.value);
    }

    @Override
    public void incrementValue(int increment) throws WrongDatatypeException {
        long l = this.getValueAsLong();
        this.value = "" + (l += (long)increment);
    }

    @Override
    public void setValue(String value, boolean initial) {
        if (initial && this.value != null) {
            throw new IllegalStateException("Value was not null but '" + this.value + "' so could not set to '" + value + "'");
        }
        this.value = value;
    }
}

