/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.csv.impl.memory;

import org.xydra.csv.ICell;
import org.xydra.csv.IReadableRow;

public abstract class AbstractReadableRow
implements IReadableRow {
    protected static final String ROW_KEY = "ROW";
    public static final long serialVersionUID = -1859613946021005526L;
    private final String key;

    AbstractReadableRow(String key) {
        this.key = key;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    protected boolean contains(String[] array, String value) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getValue(String columnName) {
        ICell cell = this.getOrCreateCell(columnName, false);
        return cell == null ? "null" : cell.getValue();
    }

    public abstract ICell getOrCreateCell(String var1, boolean var2);

    @Override
    public double getValueAsDouble(String columnName) {
        ICell cell = this.getOrCreateCell(columnName, false);
        if (cell == null) {
            return 0.0;
        }
        return cell.getValueAsDouble();
    }

    @Override
    public long getValueAsLong(String columnName) {
        ICell cell = this.getOrCreateCell(columnName, false);
        if (cell == null) {
            return 0L;
        }
        return cell.getValueAsLong();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{ \n");
        for (String colName : this.getColumnNames()) {
            buf.append("  " + colName + ": '" + this.getValue(colName) + "', \n");
        }
        buf.append(" }");
        return buf.toString();
    }
}

