/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.util;

import com.calpano.common.shared.util.SharedExceptionUtils_GwtEmul;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.sharedutils.ReflectionUtils;

public class ExceptionUtils
extends SharedExceptionUtils_GwtEmul {
    private static final Logger log = LoggerFactory.getLogger(ExceptionUtils.class);

    public static String toHtmlStringWithStacktrace(Throwable t) {
        return ExceptionUtils.toStringWithStacktrace(t, "<br/>\n").toString();
    }

    public static StringBuilder toStringWithStacktrace(Throwable t, String lineEnd) {
        StringBuilder buf = new StringBuilder();
        buf.append("<b>" + t.getClass().getCanonicalName() + "</b>" + lineEnd);
        buf.append("<b>" + t.getMessage() + "</b>" + lineEnd);
        buf.append("First 300 lines of stacktrace:" + lineEnd);
        buf.append(ReflectionUtils.firstNLines((Throwable)t, (int)300));
        return buf;
    }

    public static void generateOutOfMemoryError(Writer w) throws IOException {
        log.warn("Generate out of memory error");
        int size = 0;
        w.write("Ate KB = ");
        w.flush();
        LinkedList<Byte[]> l = new LinkedList<Byte[]>();
        while (true) {
            Byte[] a = new Byte[1024];
            l.add(a);
            size += 1024;
            if (l.size() % 50 == 0) {
                w.write(" " + l.size() + " (" + size + ")");
                w.flush();
            }
            if (l.size() % 1024 != 0) continue;
            w.write("<br/>\n");
            w.flush();
        }
    }

    public static void generateNullPointerException() {
        log.warn("Generate a NPE now");
        String s = null;
        int i = s.length();
    }

    public static void main(String[] args) {
        System.out.println(ExceptionUtils.getStacktraceAsString());
    }
}

