/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.user.base;

import com.calpano.common.server.user.index.EmailIndex;
import com.calpano.common.server.user.index.UsernameIndex;
import com.calpano.common.shared.user.base.IIdentificationIndex;
import de.xam.texthtml.text.EncTool;
import org.xydra.base.XId;
import org.xydra.core.XX;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.store.session.SessionModel;

public class ServerIdentificationIndex
implements IIdentificationIndex {
    private static final Logger log = LoggerFactory.getLogger(ServerIdentificationIndex.class);
    public static final XId ACTOR = XX.toId((String)"_ServerIdentificationIndex");
    private final SessionModel userModel;

    public ServerIdentificationIndex(SessionModel userModel) {
        this.userModel = userModel;
    }

    public void indexEmail(XId userId, String oldEmail, String newEmail) {
        String[] stringArray;
        String[] stringArray2;
        if (oldEmail != null && oldEmail.equals(newEmail)) {
            log.warn("NOP operation: Tried to set email '" + EncTool.htmlText((String)newEmail) + "' on user '" + userId + "' which it had already");
            return;
        }
        EmailIndex emailIndex = new EmailIndex(this.userModel);
        if (emailIndex.containsEmail(newEmail)) {
            throw new IllegalArgumentException("Email address " + EncTool.htmlText((String)newEmail) + " is already used");
        }
        if (oldEmail == null) {
            stringArray2 = new String[]{};
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = oldEmail;
        }
        if (newEmail == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = newEmail;
        }
        emailIndex.batchUpdate(userId, stringArray2, stringArray);
    }

    public void indexUsername(XId userId, String oldUsername, String newUsername) {
        String[] stringArray;
        String[] stringArray2;
        if (oldUsername != null && oldUsername.equals(newUsername)) {
            log.warn("NOP operation: Tried to set email '" + EncTool.htmlText((String)newUsername) + "' on user '" + userId + "' which it had already");
            return;
        }
        UsernameIndex usernameIndex = new UsernameIndex(this.userModel);
        if (usernameIndex.contains(newUsername)) {
            throw new IllegalArgumentException("Username " + EncTool.htmlText((String)newUsername) + " is already used");
        }
        if (oldUsername == null) {
            stringArray2 = new String[]{};
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = oldUsername;
        }
        if (newUsername == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = newUsername;
        }
        usernameIndex.batchUpdate(userId, stringArray2, stringArray);
    }

    public static synchronized ServerIdentificationIndex instance(SessionModel userModel) {
        return new ServerIdentificationIndex(userModel);
    }
}

