/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.local;

import de.xam.p13n.shared.time.TimeProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.apache.commons.io.IOUtils;
import org.xydra.common.NanoClock;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class ShutdownServer
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ShutdownServer.class);
    private static final int TIMEOUT_SERVER = 2000;
    private static final int TIMEOUT_CLIENT = 500;
    private static final int TIMEOUT_SELFSHUTDOWN = 1000;
    private final int port;
    private boolean stop = false;
    private ServerSocket serversocket;
    private final IGetStopped stopper;
    private long startTime;

    public ShutdownServer(int port, IGetStopped stopper) {
        this.port = port;
        this.stopper = stopper;
    }

    public void startListeningForStopRequests() {
        Thread t = new Thread(this);
        t.setName("ShutdownServer-" + this.port);
        t.start();
    }

    public void stopListeningForStopRequests() {
        this.stop = true;
        if (this.serversocket != null) {
            try {
                this.serversocket.close();
            }
            catch (IOException e) {
                log.warn("could not close server socket", (Throwable)e);
            }
        }
    }

    @Override
    public void run() {
        this.startTime = TimeProvider.getCurrentTimeInMillis();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("shutdown server thread could not sleep", e);
        }
        try {
            this.serversocket = new ServerSocket(this.port);
            this.serversocket.setSoTimeout(2000);
            log.info("Listening for connection on port " + this.port + " for shut-down");
            while (!this.stop) {
                try {
                    Socket connectionsocket = this.serversocket.accept();
                    log.info("Connected");
                    this.shutdown();
                }
                catch (SocketTimeoutException e) {
                }
                catch (SocketException se) {
                    log.info("ShutdownServer port closed.");
                }
                catch (IOException e) {
                    log.warn("Got exception, but will just continue to run: ", (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            log.error("Fatal exception: ", (Throwable)e);
        }
    }

    private void shutdown() {
        log.info("Shutting down after request on my shutdown port " + this.port);
        if (this.stopper == null) {
            log.warn("I have no stopper, so I'll stop the whole JVM");
            System.exit(0);
        } else {
            boolean success = this.stopper.stop();
            log.debug("Stop success = " + success);
        }
    }

    public static void sendStopToLocalhost(int port) throws UnknownHostException, IOException {
        boolean endpointIsAlive;
        InetSocketAddress endpoint = new InetSocketAddress("localhost", port);
        Socket socket = new Socket();
        try {
            log.debug("Connecting to remote port and sending stop signal");
            socket.connect(endpoint, 500);
            log.debug("Remote port answered and should shut down now");
            endpointIsAlive = true;
            OutputStream out = socket.getOutputStream();
            IOUtils.write((String)"stop", (OutputStream)out);
            out.close();
            socket.close();
        }
        catch (ConnectException | SocketTimeoutException e) {
            log.debug("Remote port did not accept");
            endpointIsAlive = false;
            System.out.println("No other instance of tool running.");
        }
        NanoClock clock = new NanoClock();
        clock.start();
        while (endpointIsAlive) {
            try {
                log.debug("Sleeping a little to let the other app shut down cleanly");
                Thread.sleep(100L);
                try {
                    socket.connect(endpoint, 500);
                }
                catch (ConnectException e) {
                    log.debug("Remote app is down (at least the shutdown port :-)");
                    endpointIsAlive = false;
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void main(String[] args) throws UnknownHostException, IOException {
        Socket s = new Socket("localhost", 8766);
        OutputStream out = s.getOutputStream();
        IOUtils.write((String)"foo", (OutputStream)out);
        out.close();
        s.close();
        ShutdownServer.sendStopToLocalhost(8766);
        System.out.println("Done.");
    }

    public static ShutdownServer activateOnPort(int port, IGetStopped stopper) {
        ShutdownServer ss = new ShutdownServer(port, stopper);
        ss.startListeningForStopRequests();
        return ss;
    }

    public static interface IGetStopped {
        public boolean stop();
    }
}

