/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.admin;

import de.xam.p13n.shared.time.TimeProvider;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xydra.conf.IConfig;
import org.xydra.env.Env;
import org.xydra.restless.Restless;
import org.xydra.restless.RestlessParameter;
import org.xydra.restless.utils.SharedHtmlUtils;

public class ConfigurationService {
    public static void restless(Restless restless, String prefix) {
        ConfigurationService.addParamsFromWebXml(restless, Env.get().conf());
        restless.addMethod(prefix + "/settings", "GET", ConfigurationService.class, "showSettings", true, new RestlessParameter[0]);
    }

    public static void addParamsFromWebXml(Restless restless, IConfig conf) {
        for (Map.Entry e : restless.getWebXmlInitParameter().entrySet()) {
            System.out.println("Adding '" + (String)e.getKey() + "'='" + (String)e.getValue() + "'");
            conf.setStrings((String)e.getKey(), new String[]{(String)e.getValue()});
        }
    }

    public void showSettings(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setCharacterEncoding("utf-8");
        resp.setContentType("text/html");
        resp.getWriter().println(ConfigurationService.toHTML());
        resp.getWriter().flush();
        resp.getWriter().close();
    }

    public static String toHTML() {
        StringBuffer html = new StringBuffer();
        html.append("<h4>Processed values</h4>");
        HashMap<String, String> defined = new HashMap<String, String>();
        defined.put("is faketime? (read-only)", "" + TimeProvider.isFakeTime());
        defined.put("time millis (read-only)", "" + TimeProvider.getCurrentTimeInMillis());
        defined.put("time nice (read-only)", "" + TimeProvider.getCurrentTime());
        html.append(SharedHtmlUtils.toDefinitionList(defined));
        html.append("<h4>Raw values</h4>");
        html.append(SharedHtmlUtils.toDefinitionList((Map)Env.get().conf().asMap()));
        return html.toString();
    }
}

