/*
 * Decompiled with CFR 0.152.
 */
package com.sonicmetrics.gaeserver.rest;

import com.google.appengine.labs.repackaged.org.json.JSONException;
import com.google.appengine.labs.repackaged.org.json.JSONWriter;
import com.sonicmetrics.gaeserver.rest.SonicResource;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletResponse;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.Restless;
import org.xydra.restless.RestlessParameter;
import org.xydra.restless.utils.ServletUtils;

public class TimeResource
extends SonicResource {
    private static final Logger log = LoggerFactory.getLogger(TimeResource.class);

    public static void restless(Restless restless, boolean allowAll) {
        RestlessParameter[] timeParams = new RestlessParameter[]{new RestlessParameter("callback", null)};
        restless.addMethod("/time", "GET", TimeResource.class, "time_v1", !allowAll, timeParams);
        restless.addMethod("/time", "POST", TimeResource.class, "time_v1", !allowAll, timeParams);
        restless.addMethod("/v2/time", "GET", TimeResource.class, "time_v2", !allowAll, timeParams);
        restless.addMethod("/v2/time", "POST", TimeResource.class, "time_v2", !allowAll, timeParams);
    }

    public static void time_v1(HttpServletResponse res, String callback) throws IOException {
        ServletUtils.headers((HttpServletResponse)res, (int)200, (long)-1L, (String)"application/json");
        PrintWriter w = res.getWriter();
        long now = System.currentTimeMillis();
        if (TimeResource.isDefined(callback)) {
            ((Writer)w).write(callback + "(" + now + ")");
        } else {
            ((Writer)w).write("" + now);
        }
        ((Writer)w).flush();
        ((Writer)w).close();
        log.info("Time at server reported as " + now);
    }

    public static void time_v2(HttpServletResponse res, String callback) throws IOException, JSONException {
        ServletUtils.headers((HttpServletResponse)res, (int)200, (long)-1L, (String)"application/json");
        PrintWriter w = res.getWriter();
        long now = System.currentTimeMillis();
        StringWriter sw = new StringWriter();
        new JSONWriter((Writer)sw).object().key("time").value(now).key("apiversion").value((Object)"2").key("mood").value((Object)":-)").endObject();
        if (TimeResource.isDefined(callback)) {
            ((Writer)w).write(callback + "(" + sw.getBuffer() + ")");
        } else {
            ((Writer)w).write("" + sw.getBuffer());
        }
        ((Writer)w).flush();
        ((Writer)w).close();
        log.info("Time at server reported as " + now);
    }
}

