/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.mockito.ReturnValues;
import org.mockito.configuration.AnnotationEngine;
import org.mockito.configuration.AnnotationEngineHolder;
import org.mockito.configuration.DefaultMockitoConfiguration;
import org.mockito.configuration.IMockitoConfiguration;
import org.mockito.exceptions.Reporter;
import org.mockito.stubbing.Answer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockitoConfiguration
implements IMockitoConfiguration {
    private final IMockitoConfiguration delegate = new DefaultMockitoConfiguration();

    static void assertNoAnnotations(Class<? extends Annotation> annotation, Field field, Class ... undesiredAnnotations) {
        for (Class undesiredAnnotation : undesiredAnnotations) {
            if (!field.isAnnotationPresent(undesiredAnnotation)) continue;
            new Reporter().unsupportedCombinationOfAnnotations(undesiredAnnotation.getSimpleName(), annotation.getSimpleName());
        }
    }

    public boolean cleansStackTrace() {
        return this.delegate.cleansStackTrace();
    }

    public boolean enableClassCache() {
        return this.delegate.enableClassCache();
    }

    public AnnotationEngine getAnnotationEngine() {
        return AnnotationEngineHolder.getAnnotationEngine();
    }

    public Answer<Object> getDefaultAnswer() {
        return this.delegate.getDefaultAnswer();
    }

    public ReturnValues getReturnValues() {
        return this.delegate.getReturnValues();
    }
}

