/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.uibinder;

import com.google.gwt.event.dom.client.DomEvent;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Widget;
import com.googlecode.gwt.test.exceptions.GwtTestUiBinderException;
import com.googlecode.gwt.test.exceptions.ReflectionException;
import com.googlecode.gwt.test.uibinder.UiBinderParser;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UiBinderInvocationHandler
implements InvocationHandler {
    private static final Map<Class<?>, GwtEvent<?>> EVENT_PROTOTYPES = new HashMap();
    private final Class<UiBinder<?, ?>> proxiedClass;

    UiBinderInvocationHandler(Class<UiBinder<?, ?>> proxiedClass) {
        this.proxiedClass = proxiedClass;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("createAndBindUi")) {
            return this.createAndBindUi(args[0]);
        }
        throw new GwtTestUiBinderException("Not managed method for UiBinder : " + method.getName());
    }

    private <H extends EventHandler> void addHandlers(Object owner) {
        Map<Method, UiHandler> uiHandlerMethods = GwtReflectionUtils.getAnnotatedMethod(owner.getClass(), UiHandler.class);
        for (Map.Entry<Method, UiHandler> entry : uiHandlerMethods.entrySet()) {
            for (String uiFieldName : entry.getValue().value()) {
                Widget uiField = (Widget)GwtReflectionUtils.getPrivateFieldValue(owner, uiFieldName);
                GwtEvent.Type<?> eventType = this.getEventType(entry.getKey());
                EventHandler handler = this.createHandler(uiField, entry.getKey(), owner);
                if (eventType instanceof DomEvent.Type) {
                    uiField.addDomHandler(handler, (DomEvent.Type)eventType);
                    continue;
                }
                if (uiField instanceof HasValueChangeHandlers && handler instanceof ValueChangeHandler) {
                    ((HasValueChangeHandlers)uiField).addValueChangeHandler((ValueChangeHandler)handler);
                    continue;
                }
                uiField.addHandler(handler, eventType);
            }
        }
    }

    private Object createAndBindUi(Object owner) {
        UiBinderParser parser = new UiBinderParser();
        Object rootComponent = parser.createUiComponent(this.proxiedClass, owner);
        this.addHandlers(owner);
        return rootComponent;
    }

    private InvocationHandler createEventHandlerInvocationHandler(final Method uiHandlerMethod, final Object uiHandlerOwner) {
        return new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return GwtReflectionUtils.callPrivateMethod(uiHandlerOwner, uiHandlerMethod, args);
            }
        };
    }

    private EventHandler createHandler(Widget uiField, Method uiHandlerMethod, Object uiHandlerOwner) {
        Class<EventHandler> eventHandlerClass = this.findHandlerClass(uiHandlerMethod);
        InvocationHandler eventHandlerInvocationHandler = this.createEventHandlerInvocationHandler(uiHandlerMethod, uiHandlerOwner);
        return (EventHandler)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{eventHandlerClass}, eventHandlerInvocationHandler);
    }

    private Class<EventHandler> findHandlerClass(Method uiHandlerMethod) {
        Class<?> eventTypeClass = uiHandlerMethod.getParameterTypes()[0];
        String eventHandlerClassName = eventTypeClass.getName().substring(0, eventTypeClass.getName().lastIndexOf("Event")) + "Handler";
        try {
            return GwtReflectionUtils.getClass(eventHandlerClassName);
        }
        catch (ClassNotFoundException e) {
            String anotherEventHandlerClassName = eventTypeClass.getName() + ".Handler";
            try {
                return GwtReflectionUtils.getClass(anotherEventHandlerClassName);
            }
            catch (ClassNotFoundException e2) {
                throw new GwtTestUiBinderException("Cannot find handler class for event type '" + eventTypeClass.getName() + "'. By convention, it should be '" + eventHandlerClassName + "' or '" + anotherEventHandlerClassName + "'");
            }
        }
    }

    private GwtEvent.Type<?> getEventType(Method method) {
        Class<?> eventTypeClass = method.getParameterTypes()[0];
        try {
            return (GwtEvent.Type)GwtReflectionUtils.callStaticMethod(eventTypeClass, "getType", new Object[0]);
        }
        catch (ReflectionException e) {
            GwtEvent eventPrototype = EVENT_PROTOTYPES.get(eventTypeClass);
            if (eventPrototype == null) {
                eventPrototype = (GwtEvent)GwtReflectionUtils.instantiateClass(eventTypeClass);
                EVENT_PROTOTYPES.put(eventTypeClass, eventPrototype);
            }
            return eventPrototype.getAssociatedType();
        }
    }
}

