/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.rpc;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.googlecode.gwt.test.GwtCreateHandler;
import com.googlecode.gwt.test.exceptions.GwtTestRpcException;
import com.googlecode.gwt.test.internal.GwtClassPool;
import com.googlecode.gwt.test.rpc.DeepCopy;
import com.googlecode.gwt.test.rpc.GwtRpcExceptionHandler;
import com.googlecode.gwt.test.rpc.GwtRpcInvocationHandler;
import com.googlecode.gwt.test.rpc.GwtRpcSerializerHandler;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javassist.CtClass;
import javassist.bytecode.annotation.AnnotationImpl;
import javassist.bytecode.annotation.StringMemberValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteServiceCreateHandler
implements GwtCreateHandler {
    private static final Logger logger = LoggerFactory.getLogger(RemoteServiceCreateHandler.class);
    private final GwtRpcExceptionHandler exceptionHandler = this.getExceptionHandler();
    private final GwtRpcSerializerHandler serializerHander = this.getSerializerHandler();

    @Override
    public Object create(Class<?> classLiteral) throws Exception {
        if (!RemoteService.class.isAssignableFrom(classLiteral)) {
            return null;
        }
        String className = classLiteral.getName();
        logger.debug("Try to create Remote service class " + className);
        String asyncName = className + "Async";
        String relativePath = this.getRemoveServiceRelativePath(classLiteral);
        Class<?> asyncClazz = GwtReflectionUtils.getClass(asyncName);
        if (asyncClazz == null) {
            throw new GwtTestRpcException("Remote serivce Async class not found : " + asyncName);
        }
        logger.debug("Searching remote service implementing " + className);
        Object service = this.findService(classLiteral, relativePath);
        if (service == null) {
            return null;
        }
        GwtRpcInvocationHandler handler = new GwtRpcInvocationHandler(asyncClazz, service, this.exceptionHandler, this.serializerHander);
        return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{asyncClazz}, (InvocationHandler)handler);
    }

    protected abstract Object findService(Class<?> var1, String var2);

    protected GwtRpcExceptionHandler getExceptionHandler() {
        return new DefaultGwtRpcExceptionHandler();
    }

    protected GwtRpcSerializerHandler getSerializerHandler() {
        return new DefaultGwtRpcSerializerHandler();
    }

    private String getRemoveServiceRelativePath(Class<?> clazz) {
        Object[] annotations;
        CtClass ctClass = GwtClassPool.getCtClass(clazz);
        for (Object o : annotations = ctClass.getAvailableAnnotations()) {
            AnnotationImpl annotation;
            if (!Proxy.isProxyClass(o.getClass()) || !(annotation = (AnnotationImpl)Proxy.getInvocationHandler(o)).getTypeName().equals(RemoteServiceRelativePath.class.getName())) continue;
            return ((StringMemberValue)annotation.getAnnotation().getMemberValue("value")).getValue();
        }
        throw new GwtTestRpcException("Cannot find the '@" + RemoteServiceRelativePath.class.getSimpleName() + "' annotation on RemoteService interface '" + clazz.getName() + "'");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultGwtRpcSerializerHandler
    implements GwtRpcSerializerHandler {
        private DefaultGwtRpcSerializerHandler() {
        }

        @Override
        public <T> T serializeUnserialize(T o) throws Exception {
            return DeepCopy.copy(o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultGwtRpcExceptionHandler
    implements GwtRpcExceptionHandler {
        private DefaultGwtRpcExceptionHandler() {
        }

        @Override
        public void handle(Throwable t, AsyncCallback<?> callback) {
            callback.onFailure(t);
        }
    }
}

