/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.rewrite;

import com.google.gwt.dev.asm.ClassAdapter;
import com.google.gwt.dev.asm.ClassVisitor;
import com.google.gwt.dev.asm.MethodAdapter;
import com.google.gwt.dev.asm.MethodVisitor;
import com.google.gwt.dev.asm.Type;
import java.util.HashMap;
import java.util.Map;

class UseMirroredClasses
extends ClassAdapter {
    private final String className;

    public UseMirroredClasses(ClassVisitor cv, String className) {
        super(cv);
        this.className = className;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null) {
            return null;
        }
        return new MethodInterceptor(mv, this.className);
    }

    private static class MethodInterceptor
    extends MethodAdapter {
        private static HashMap<String, HashMap<String, String>> mirrorMap = new HashMap();
        private final String className;

        protected MethodInterceptor(MethodVisitor mv, String className) {
            super(mv);
            this.className = className;
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            Map mirroredMethods = mirrorMap.get(owner);
            if (mirroredMethods == null) {
                super.visitMethodInsn(opcode, owner, name, desc);
                return;
            }
            String mirrorClassMethod = (String)mirroredMethods.get(name);
            if (mirrorClassMethod == null) {
                super.visitMethodInsn(opcode, owner, name, desc);
                return;
            }
            String[] temp = mirrorClassMethod.split(":");
            if (temp.length < 2) {
                super.visitMethodInsn(opcode, owner, name, desc);
                return;
            }
            String mirrorClass = temp[0];
            String mirrorMethod = temp[1];
            if (this.className.equals(mirrorClass.replace("/", "."))) {
                super.visitMethodInsn(opcode, owner, name, desc);
                return;
            }
            if (opcode == 184) {
                super.visitMethodInsn(opcode, mirrorClass, mirrorMethod, desc);
                return;
            }
            Type[] argTypes = Type.getArgumentTypes((String)desc);
            Type[] newArgTypes = new Type[argTypes.length + 1];
            newArgTypes[0] = Type.getType((String)("L" + owner + ";"));
            System.arraycopy(argTypes, 0, newArgTypes, 1, argTypes.length);
            String newDesc = Type.getMethodDescriptor((Type)Type.getReturnType((String)desc), (Type[])newArgTypes);
            super.visitMethodInsn(184, mirrorClass, mirrorMethod, newDesc);
        }

        static {
            HashMap<String, String> logRecordMethods = new HashMap<String, String>();
            logRecordMethods.put("getLoggerName", "com/google/gwt/logging/impl/DevModeLoggingFixes:getLoggerName");
            mirrorMap.put("java/util/logging/LogRecord", logRecordMethods);
            HashMap<String, String> logManagerMethods = new HashMap<String, String>();
            logManagerMethods.put("getLogger", "com/google/gwt/logging/impl/DevModeLoggingFixes:logManagerGetLogger");
            mirrorMap.put("java/util/logging/LogManager", logManagerMethods);
            HashMap<String, String> loggerMethods = new HashMap<String, String>();
            loggerMethods.put("getName", "com/google/gwt/logging/impl/DevModeLoggingFixes:getName");
            loggerMethods.put("getLogger", "com/google/gwt/logging/impl/DevModeLoggingFixes:loggerGetLogger");
            mirrorMap.put("java/util/logging/Logger", loggerMethods);
        }
    }
}

