/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.resources;

import com.googlecode.gwt.test.internal.AfterTestCallback;
import com.googlecode.gwt.test.internal.AfterTestCallbackManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TextResourceReader
implements AfterTestCallback {
    private static final TextResourceReader INSTANCE = new TextResourceReader();
    private final Map<URL, String> cache = new HashMap<URL, String>();

    public static TextResourceReader get() {
        return INSTANCE;
    }

    private TextResourceReader() {
        AfterTestCallbackManager.get().registerCallback(this);
    }

    @Override
    public void afterTest() throws Throwable {
        this.cache.clear();
    }

    public String readFiles(List<URL> urls) throws UnsupportedEncodingException, IOException {
        StringBuilder sb = new StringBuilder();
        for (URL url : urls) {
            sb.append(this.readFile(url));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(URL url) throws UnsupportedEncodingException, IOException {
        if (!this.cache.containsKey(url)) {
            StringBuilder sb = new StringBuilder();
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\r\n");
                }
                if (sb.length() > 0) {
                    sb.delete(sb.length() - "\r\n".length(), sb.length());
                }
                this.cache.put(url, sb.toString());
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        return this.cache.get(url);
    }
}

