/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.patchers.dom;

import com.google.gwt.dom.client.Style;
import com.googlecode.gwt.test.internal.utils.GwtStyleUtils;
import com.googlecode.gwt.test.patchers.PatchClass;
import com.googlecode.gwt.test.patchers.PatchMethod;
import java.util.LinkedHashMap;

@PatchClass(value=Style.class)
class StylePatcher {
    private static final String STYLE_BORDER_BOTTOM_WIDTH = "border-bottom-width";
    private static final String STYLE_BORDER_LEFT_WIDTH = "border-left-width";
    private static final String STYLE_BORDER_RIGHT_WIDTH = "border-right-width";
    private static final String STYLE_BORDER_TOP_WIDTH = "border-top-width";

    StylePatcher() {
    }

    @PatchMethod
    static void clearBorderWidth(Style style) {
        LinkedHashMap<String, String> properties = GwtStyleUtils.getStyleProperties(style);
        properties.remove(STYLE_BORDER_BOTTOM_WIDTH);
        properties.remove(STYLE_BORDER_LEFT_WIDTH);
        properties.remove(STYLE_BORDER_RIGHT_WIDTH);
        properties.remove(STYLE_BORDER_TOP_WIDTH);
    }

    @PatchMethod
    static void clearFloat(Style style) {
        GwtStyleUtils.getStyleProperties(style).remove("float");
    }

    @PatchMethod
    static String getBorderWidth(Style style) {
        return style.getProperty(STYLE_BORDER_TOP_WIDTH);
    }

    @PatchMethod
    static void setBorderWidth(Style style, double value, Style.Unit unit) {
        double modulo = value % 1.0;
        String completeValue = modulo == 0.0 ? Integer.toString((int)value) + unit.getType() : Double.toString(value) + unit.getType();
        GwtStyleUtils.setProperty(style, STYLE_BORDER_BOTTOM_WIDTH, completeValue);
        GwtStyleUtils.setProperty(style, STYLE_BORDER_LEFT_WIDTH, completeValue);
        GwtStyleUtils.setProperty(style, STYLE_BORDER_RIGHT_WIDTH, completeValue);
        GwtStyleUtils.setProperty(style, STYLE_BORDER_TOP_WIDTH, completeValue);
    }

    @PatchMethod
    static void setFloat(Style style, Style.Float value) {
        GwtStyleUtils.setProperty(style, "float", value.getCssName());
    }

    @PatchMethod
    static void setPropertyImpl(Style style, String propertyName, String propertyValue) {
        GwtStyleUtils.setProperty(style, propertyName, propertyValue);
    }
}

