/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.patchers.dom;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.Text;
import com.googlecode.gwt.test.exceptions.GwtTestDomException;
import com.googlecode.gwt.test.internal.utils.JsoUtils;
import com.googlecode.gwt.test.patchers.PatchClass;
import com.googlecode.gwt.test.patchers.PatchMethod;
import com.googlecode.gwt.test.utils.JavaScriptObjects;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PatchClass(value=Node.class)
class NodePatcher {
    NodePatcher() {
    }

    @PatchMethod
    static Node appendChild(Node parent, Node newChild) {
        return NodePatcher.insertAtIndex(parent, newChild, -1);
    }

    @PatchMethod
    static Node cloneNode(Node node, boolean deep) {
        return (Node)JsoUtils.cloneJso((JavaScriptObject)node, deep).cast();
    }

    @PatchMethod
    static NodeList<Node> getChildNodes(Node node) {
        return JsoUtils.getChildNodes(node);
    }

    @PatchMethod
    static Node getFirstChild(Node node) {
        List<Node> list = JsoUtils.getChildNodeInnerList(node);
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @PatchMethod
    static Node getLastChild(Node node) {
        List<Node> list = JsoUtils.getChildNodeInnerList(node);
        if (list.size() == 0) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    @PatchMethod
    static Node getNextSibling(Node node) {
        Node parent = node.getParentNode();
        if (parent == null) {
            return null;
        }
        List<Node> list = JsoUtils.getChildNodeInnerList(parent);
        for (int i = 0; i < list.size(); ++i) {
            Node current = list.get(i);
            if (!current.equals((Object)node) || i >= list.size() - 1) continue;
            return list.get(i + 1);
        }
        return null;
    }

    @PatchMethod
    static String getNodeName(Node node) {
        switch (node.getNodeType()) {
            case 9: {
                return "#document";
            }
            case 1: {
                Element e = (Element)node.cast();
                return e.getTagName();
            }
            case 3: {
                return "#text";
            }
            case 2: {
                return JavaScriptObjects.getString((JavaScriptObject)node, "XML_ATTR_NAME");
            }
        }
        throw new GwtTestDomException("Invalid Node type (not a Document / Element / Text / Attribute) : " + node.getNodeType());
    }

    @PatchMethod
    static short getNodeType(Node node) {
        return JsoUtils.getNodeType((JavaScriptObject)node);
    }

    @PatchMethod
    static String getNodeValue(Node node) {
        switch (node.getNodeType()) {
            case 9: {
                return null;
            }
            case 1: {
                return null;
            }
            case 3: {
                Text text = (Text)node.cast();
                return text.getData();
            }
        }
        throw new GwtTestDomException("Invalid Node type (not a Document / Element / Text : " + node.getNodeType());
    }

    @PatchMethod
    static Document getOwnerDocument(Node node) {
        return (Document)JavaScriptObjects.getObject((JavaScriptObject)node, "NODE_OWNER_DOCUMENT");
    }

    @PatchMethod
    static Node getPreviousSibling(Node node) {
        Node parent = node.getParentNode();
        if (parent == null) {
            return null;
        }
        List<Node> list = JsoUtils.getChildNodeInnerList(parent);
        for (int i = 0; i < list.size(); ++i) {
            Node current = list.get(i);
            if (!current.equals((Object)node) || i <= 0) continue;
            return list.get(i - 1);
        }
        return null;
    }

    @PatchMethod
    static boolean hasChildNodes(Node node) {
        return JsoUtils.getChildNodeInnerList(node).size() > 0;
    }

    static Node insertAtIndex(Node parent, Node newChild, int index) {
        List<Node> list = JsoUtils.getChildNodeInnerList(parent);
        Node oldParent = newChild.getParentNode();
        if (oldParent != null) {
            oldParent.removeChild(newChild);
        }
        if (index == -1 || index >= list.size()) {
            list.add(newChild);
        } else {
            list.add(index, newChild);
        }
        JsoUtils.setParentNode(newChild, parent);
        return newChild;
    }

    @PatchMethod
    static Node insertBefore(Node parent, Node newChild, Node refChild) {
        List<Node> list = JsoUtils.getChildNodeInnerList(parent);
        int index = -1;
        if (refChild != null) {
            for (int i = 0; index == -1 && i < list.size(); ++i) {
                if (!list.get(i).equals((Object)refChild)) continue;
                index = i;
            }
        }
        return NodePatcher.insertAtIndex(parent, newChild, index);
    }

    @PatchMethod
    static boolean is(JavaScriptObject object) {
        if (object == null) {
            return false;
        }
        short nodeType = ((Node)object.cast()).getNodeType();
        return nodeType > 0;
    }

    @PatchMethod
    static Node removeChild(Node oldParent, Node oldChild) {
        List<Node> list = JsoUtils.getChildNodeInnerList(oldParent);
        return list.remove(oldChild) ? oldChild : null;
    }

    @PatchMethod
    static Node replaceChild(Node parent, Node newChild, Node oldChild) {
        if (oldChild == null) {
            return null;
        }
        List<Node> list = JsoUtils.getChildNodeInnerList(parent);
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).equals((Object)oldChild)) continue;
            list.add(i, newChild);
            list.remove(oldChild);
            return oldChild;
        }
        return null;
    }

    @PatchMethod
    static void setNodeValue(Node node, String nodeValue) {
        switch (node.getNodeType()) {
            case 9: {
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                Text text = (Text)node.cast();
                text.setData(nodeValue);
            }
        }
    }
}

