/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.patchers;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.Text;
import com.google.gwt.xml.client.impl.XMLParserImpl;
import com.googlecode.gwt.test.exceptions.GwtTestPatchException;
import com.googlecode.gwt.test.internal.utils.GwtXMLParser;
import com.googlecode.gwt.test.internal.utils.JsoUtils;
import com.googlecode.gwt.test.internal.utils.PropertyContainer;
import com.googlecode.gwt.test.patchers.PatchClass;
import com.googlecode.gwt.test.patchers.PatchMethod;
import com.googlecode.gwt.test.utils.JavaScriptObjects;
import java.util.ArrayList;
import java.util.Set;

@PatchClass(value=XMLParserImpl.class)
class XMLParserImplPatcher {
    private static final String XML_ATTR_VALUE = "XML_ATTR_VALUE";

    XMLParserImplPatcher() {
    }

    @PatchMethod
    static JavaScriptObject appendChild(JavaScriptObject jsObject, JavaScriptObject newChildJs) {
        Node n = (Node)jsObject.cast();
        Node newChildNode = (Node)newChildJs.cast();
        return n.appendChild(newChildNode);
    }

    @PatchMethod
    static JavaScriptObject createCDATASection(JavaScriptObject jsObject, String data) {
        Document document = (Document)jsObject.cast();
        Text text = (Text)JsoUtils.newNode(4).cast();
        JavaScriptObjects.setProperty((JavaScriptObject)text, "NODE_OWNER_DOCUMENT", document);
        text.setData(data);
        return text;
    }

    @PatchMethod
    static JavaScriptObject createDocumentImpl(XMLParserImpl xmlParserImpl) {
        return JsoUtils.newNode(9);
    }

    @PatchMethod
    static JavaScriptObject createElement(JavaScriptObject jsObject, String tagName) {
        Document document = (Document)jsObject.cast();
        return JsoUtils.newXmlElement(document, tagName);
    }

    @PatchMethod
    static JavaScriptObject createTextNode(JavaScriptObject jsObject, String text) {
        Document document = (Document)jsObject.cast();
        return document.createTextNode(text);
    }

    @PatchMethod
    static String getAttribute(JavaScriptObject o, String name) {
        PropertyContainer properties = JsoUtils.getDomProperties((Element)o.cast());
        if ("class".equals(name)) {
            name = "className";
        }
        return (String)properties.getObject(name);
    }

    @PatchMethod
    static JavaScriptObject getAttributeNode(JavaScriptObject o, String name) {
        String value = XMLParserImplPatcher.getAttribute(o, name);
        Node attrJSO = (Node)JsoUtils.newNode(2).cast();
        JavaScriptObjects.setProperty((JavaScriptObject)attrJSO, "XML_ATTR_NAME", name);
        JavaScriptObjects.setProperty((JavaScriptObject)attrJSO, XML_ATTR_VALUE, value);
        JavaScriptObjects.setProperty((JavaScriptObject)attrJSO, "namespaceURI", XMLParserImplPatcher.getNamespaceURI(o));
        return attrJSO;
    }

    @PatchMethod
    static JavaScriptObject getAttributes(JavaScriptObject t) {
        Set attrSet = (Set)JavaScriptObjects.getObject(t, "XML_ATTR_SET");
        ArrayList<Node> list = new ArrayList<Node>();
        for (String attrName : attrSet) {
            Node attrNode = (Node)XMLParserImplPatcher.getAttributeNode(t, attrName).cast();
            list.add(attrNode);
        }
        return JsoUtils.newNodeList(list);
    }

    @PatchMethod
    static JavaScriptObject getChildNodes(JavaScriptObject t) {
        Node n = (Node)t.cast();
        return n.getChildNodes();
    }

    @PatchMethod
    static String getData(JavaScriptObject o) {
        Text text = (Text)o.cast();
        return text.getData();
    }

    @PatchMethod
    static JavaScriptObject getDocumentElement(JavaScriptObject o) {
        Document document = (Document)o.cast();
        return document.getFirstChild();
    }

    @PatchMethod
    static JavaScriptObject getElementByIdImpl(XMLParserImpl xmlParserImpl, JavaScriptObject jsoDocument, String id) {
        Document document = (Document)jsoDocument.cast();
        return document.getElementById(id);
    }

    @PatchMethod
    static JavaScriptObject getElementsByTagNameImpl(XMLParserImpl xmlParserImpl, JavaScriptObject o, String tagName) {
        NodeList nodeList;
        Node node = (Node)o.cast();
        switch (node.getNodeType()) {
            case 9: {
                Document document = (Document)node.cast();
                nodeList = document.getElementsByTagName(tagName);
                break;
            }
            case 1: {
                Element element = (Element)node.cast();
                nodeList = element.getElementsByTagName(tagName);
                break;
            }
            default: {
                nodeList = JsoUtils.newNodeList();
            }
        }
        return nodeList;
    }

    @PatchMethod
    static int getLength(JavaScriptObject o) {
        NodeList nodeList = (NodeList)o.cast();
        return nodeList.getLength();
    }

    @PatchMethod
    static String getName(JavaScriptObject o) {
        return JavaScriptObjects.getString(o, "XML_ATTR_NAME");
    }

    @PatchMethod
    static JavaScriptObject getNamedItem(JavaScriptObject t, String name) {
        NodeList attrs = (NodeList)t.cast();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node n = attrs.getItem(i);
            if (!name.equals(XMLParserImplPatcher.getName((JavaScriptObject)n))) continue;
            return n;
        }
        return null;
    }

    @PatchMethod
    static String getNamespaceURI(JavaScriptObject o) {
        return JavaScriptObjects.getString(o, "namespaceURI");
    }

    @PatchMethod
    static JavaScriptObject getNextSibling(JavaScriptObject o) {
        Node n = (Node)o.cast();
        return n.getNextSibling();
    }

    @PatchMethod
    static String getNodeName(JavaScriptObject o) {
        try {
            Node node = (Node)o.cast();
            return node.getNodeName();
        }
        catch (ClassCastException e) {
            return "";
        }
    }

    @PatchMethod
    static short getNodeType(JavaScriptObject jsObject) {
        Node node = (Node)jsObject.cast();
        return node.getNodeType();
    }

    @PatchMethod
    static String getNodeValue(JavaScriptObject o) {
        Node n = (Node)o.cast();
        switch (n.getNodeType()) {
            case 2: {
                return JavaScriptObjects.getString((JavaScriptObject)n, XML_ATTR_VALUE);
            }
            case 1: {
                Element e = (Element)n.cast();
                return e.getInnerText();
            }
        }
        return n.getNodeValue();
    }

    @PatchMethod
    static Document getOwnerDocument(JavaScriptObject o) {
        Node n = (Node)o.cast();
        return n.getOwnerDocument();
    }

    @PatchMethod
    static JavaScriptObject getPreviousSibling(JavaScriptObject o) {
        Node n = (Node)o.cast();
        return n.getPreviousSibling();
    }

    @PatchMethod
    static String getTagName(JavaScriptObject o) {
        Element e = (Element)o.cast();
        return e.getTagName();
    }

    @PatchMethod
    static String getValue(JavaScriptObject o) {
        return JavaScriptObjects.getString(o, XML_ATTR_VALUE);
    }

    @PatchMethod
    static boolean hasChildNodes(JavaScriptObject jsObject) {
        Node n = (Node)jsObject.cast();
        return n.hasChildNodes();
    }

    @PatchMethod
    static JavaScriptObject item(JavaScriptObject t, int index) {
        NodeList nodeList = (NodeList)t.cast();
        return nodeList.getItem(index);
    }

    @PatchMethod
    static JavaScriptObject parseImpl(XMLParserImpl xmlParserImpl, String contents) {
        try {
            return GwtXMLParser.parse(contents);
        }
        catch (Exception e) {
            throw new GwtTestPatchException("Error while parsing XML", e);
        }
    }

    @PatchMethod
    static JavaScriptObject removeChild(JavaScriptObject jsObject, JavaScriptObject oldChildJs) {
        Node node = (Node)jsObject.cast();
        Node oldChildNode = (Node)oldChildJs.cast();
        return node.removeChild(oldChildNode);
    }

    @PatchMethod
    static void setAttribute(JavaScriptObject o, String name, String value) {
        PropertyContainer properties = JsoUtils.getDomProperties((Element)o.cast());
        properties.put(name, value);
    }

    @PatchMethod
    static void setNodeValue(JavaScriptObject jsObject, String nodeValue) {
        Node n = (Node)jsObject.cast();
        switch (n.getNodeType()) {
            case 3: {
                Text text = (Text)n.cast();
                text.setData(nodeValue);
                break;
            }
            case 1: {
                Element element = (Element)n.cast();
                element.setInnerText(nodeValue);
                break;
            }
        }
    }
}

