/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.patchers;

import com.google.gwt.core.client.GWT;
import com.google.gwt.inject.rebind.adapter.GwtDotCreateProvider;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.internal.AbstractBindingBuilder;
import com.googlecode.gwt.test.gin.GwtTestGinException;
import com.googlecode.gwt.test.patchers.InitMethod;
import com.googlecode.gwt.test.patchers.PatchClass;
import com.googlecode.gwt.test.patchers.PatchMethod;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PatchClass(target="com.google.gwt.inject.rebind.adapter.GwtDotCreateProvider")
class GwtDotCreateProviderPatcher {
    private static final String BINDED_CLASS_FIELD = "gwtTestUtilsBindedClass";

    GwtDotCreateProviderPatcher() {
    }

    @PatchMethod
    static <T> ScopedBindingBuilder bind(LinkedBindingBuilder<T> builder) {
        if (!(builder instanceof AbstractBindingBuilder)) {
            throw new GwtTestGinException("Not managed " + LinkedBindingBuilder.class.getSimpleName() + " implementation : " + builder.getClass().getName());
        }
        Binding binding = (Binding)GwtReflectionUtils.getPrivateFieldValue(builder, "binding");
        Type type = binding.getKey().getTypeLiteral().getType();
        if (!(type instanceof Class)) {
            throw new GwtTestGinException("Not managed binded type : " + type);
        }
        Constructor<T> atInjectConstructor = GwtDotCreateProviderPatcher.getAtInjectConstructor((Class)type);
        if (atInjectConstructor != null) {
            return builder.toConstructor(atInjectConstructor);
        }
        GwtDotCreateProvider gwtDotCreateProvider = GwtReflectionUtils.instantiateClass(GwtDotCreateProvider.class);
        GwtReflectionUtils.setPrivateFieldValue(gwtDotCreateProvider, BINDED_CLASS_FIELD, type);
        return builder.toProvider((Provider)gwtDotCreateProvider);
    }

    @PatchMethod
    static <T> T get(GwtDotCreateProvider<?> gwtDotCreateProvider) {
        Class bindedType = (Class)GwtReflectionUtils.getPrivateFieldValue(gwtDotCreateProvider, BINDED_CLASS_FIELD);
        return (T)GWT.create((Class)bindedType);
    }

    @InitMethod
    static void initClass(CtClass ctClass) throws CannotCompileException {
        CtField field = CtField.make((String)"private Class gwtTestUtilsBindedClass;", (CtClass)ctClass);
        ctClass.addField(field);
    }

    private static <T> Constructor<T> getAtInjectConstructor(Class<T> toInstanciate) {
        for (Constructor<?> cons : toInstanciate.getDeclaredConstructors()) {
            if (cons.getAnnotation(Inject.class) == null) continue;
            return cons;
        }
        return null;
    }
}

