/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.patchers;

import com.google.gwt.i18n.client.CurrencyData;
import com.google.gwt.i18n.client.CurrencyList;
import com.google.gwt.i18n.client.impl.CurrencyDataImpl;
import com.googlecode.gwt.test.internal.AfterTestCallback;
import com.googlecode.gwt.test.internal.AfterTestCallbackManager;
import com.googlecode.gwt.test.internal.GwtConfig;
import com.googlecode.gwt.test.internal.utils.GwtPropertiesHelper;
import com.googlecode.gwt.test.patchers.PatchClass;
import com.googlecode.gwt.test.patchers.PatchMethod;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

@PatchClass(value=CurrencyList.class)
class CurrencyListPatcher {
    private static final CurrencyDataHolder CURRENCY_DATA_HOLDER = new CurrencyDataHolder();

    CurrencyListPatcher() {
    }

    @PatchMethod
    static CurrencyData getDefaultJava(CurrencyList currencyList) {
        Locale locale = GwtConfig.get().getModuleRunner().getLocale();
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        return CURRENCY_DATA_HOLDER.getCurrencyData(locale);
    }

    private static class CurrencyDataHolder
    implements AfterTestCallback {
        private final Map<Locale, CurrencyData> currencyDatas = new HashMap<Locale, CurrencyData>();

        private CurrencyDataHolder() {
            AfterTestCallbackManager.get().registerCallback(this);
        }

        public void afterTest() throws Throwable {
            this.currencyDatas.clear();
        }

        CurrencyData getCurrencyData(Locale locale) {
            CurrencyData currencyData = this.currencyDatas.get(locale);
            if (currencyData == null) {
                currencyData = this.createCurrencyData(locale);
                this.currencyDatas.put(locale, currencyData);
            }
            return currencyData;
        }

        private CurrencyData createCurrencyData(Locale locale) {
            Properties currencyData = GwtPropertiesHelper.get().getLocalizedProperties("com/google/gwt/i18n/client/impl/cldr/CurrencyData", locale);
            Properties currencyExtra = GwtPropertiesHelper.get().getProperties("com/google/gwt/i18n/client/constants/CurrencyExtra");
            Properties numberConstants = GwtPropertiesHelper.get().getLocalizedProperties("com/google/gwt/i18n/client/constants/NumberConstantsImpl", locale);
            Set<Object> keySet = currencyData.keySet();
            Object[] currencies = new String[keySet.size()];
            keySet.toArray(currencies);
            Arrays.sort(currencies);
            String defCurrencyCode = numberConstants.getProperty("defCurrencyCode");
            if (defCurrencyCode == null) {
                defCurrencyCode = "USD";
            }
            CurrencyDataImpl defCurrencyData = new CurrencyDataImpl(defCurrencyCode, defCurrencyCode, 2, "");
            for (Object currencyCode : currencies) {
                String currencyEntry = currencyData.getProperty((String)currencyCode);
                String[] currencySplit = currencyEntry.split("\\|");
                Object currencySymbol = null;
                if (currencySplit.length > 1 && currencySplit[1].length() > 0) {
                    currencySymbol = currencySplit[1];
                }
                int currencyFractionDigits = 2;
                if (currencySplit.length > 2 && currencySplit[2].length() > 0) {
                    try {
                        currencyFractionDigits = Integer.valueOf(currencySplit[2]);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                int currencyFlags = currencyFractionDigits;
                String extraData = currencyExtra.getProperty((String)currencyCode);
                String portableSymbol = "";
                if (extraData != null) {
                    String[] extraSplit = extraData.split("\\|");
                    portableSymbol = extraSplit[0];
                    if (extraSplit.length > 1) {
                        if (extraSplit[1].contains("SymPrefix")) {
                            currencyFlags |= 0x10;
                        } else if (extraSplit[1].contains("SymSuffix")) {
                            currencyFlags |= 0x18;
                        }
                        if (extraSplit[1].contains("ForceSpace")) {
                            currencyFlags |= 0x60;
                        } else if (extraSplit[1].contains("ForceNoSpace")) {
                            currencyFlags |= 0x40;
                        }
                    }
                    if (extraSplit.length > 2 && extraSplit[2].length() > 0) {
                        currencySymbol = extraSplit[2];
                    }
                    if (currencySymbol == null && portableSymbol.length() > 0) {
                        currencySymbol = portableSymbol;
                    }
                }
                if (currencySymbol == null) {
                    currencySymbol = currencyCode;
                }
                if (!((String)currencyCode).equals(defCurrencyCode)) continue;
                return new CurrencyDataImpl((String)currencyCode, (String)currencySymbol, currencyFlags, portableSymbol);
            }
            return defCurrencyData;
        }
    }
}

