/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.handlers;

import com.googlecode.gwt.test.GwtCreateHandler;
import com.googlecode.gwt.test.exceptions.GwtTestConfigurationException;
import com.googlecode.gwt.test.internal.GwtConfig;
import com.googlecode.gwt.test.internal.ModuleData;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeferredGenerateWithCreateHandler
implements GwtCreateHandler {
    private Set<Class<?>> customGeneratedClasses;

    @Override
    public Object create(Class<?> classLiteral) throws Exception {
        if (this.customGeneratedClasses == null) {
            this.customGeneratedClasses = this.initCustomGeneratedClasses();
        }
        for (Class<?> clazz : this.customGeneratedClasses) {
            if (!clazz.isAssignableFrom(classLiteral)) continue;
            throw new GwtTestConfigurationException("A custom Generator should be used to instanciate '" + classLiteral.getName() + "', but gwt-test-utils does not support GWT compiler API, so you have to add our own GwtCreateHandler with 'GwtTest.addGwtCreateHandler(..)' method or to declare your tested object with @Mock");
        }
        return null;
    }

    private Set<Class<?>> initCustomGeneratedClasses() {
        HashSet result = new HashSet();
        String moduleName = GwtConfig.get().getTestedModuleName();
        for (String className : ModuleData.get(moduleName).getCustomGeneratedClasses()) {
            try {
                result.add(GwtReflectionUtils.getClass(className));
            }
            catch (ClassNotFoundException e) {
                throw new GwtTestConfigurationException("Cannot find class configured to be instanced with a custom 'generate-with' Generator : '" + className + "'");
            }
        }
        return result;
    }
}

