/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal;

import com.google.gwt.user.client.ui.UIObject;
import com.googlecode.gwt.test.GwtModule;
import com.googlecode.gwt.test.GwtModuleRunner;
import com.googlecode.gwt.test.exceptions.GwtTestConfigurationException;
import com.googlecode.gwt.test.exceptions.GwtTestException;
import com.googlecode.gwt.test.internal.AfterTestCallback;
import com.googlecode.gwt.test.internal.AfterTestCallbackManager;
import com.googlecode.gwt.test.internal.GwtFactory;
import com.googlecode.gwt.test.internal.ModuleData;
import com.googlecode.gwt.test.uibinder.UiObjectTagFactory;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GwtConfig
implements AfterTestCallback {
    private static final GwtConfig INSTANCE = new GwtConfig();
    private final UIObject.DebugIdImpl disabledInstance = new UIObject.DebugIdImpl();
    private final UIObject.DebugIdImpl enabledInstance = new UIObject.DebugIdImplEnabled();
    private GwtModuleRunner gwtModuleRunner;
    private String moduleAlias;
    private String testedModuleName;
    private final List<UiObjectTagFactory<?>> uiObjectTagFactories = new ArrayList();

    public static GwtConfig get() {
        return INSTANCE;
    }

    private GwtConfig() {
        AfterTestCallbackManager.get().registerFinalCallback(this);
    }

    @Override
    public void afterTest() throws Throwable {
        this.gwtModuleRunner = null;
        this.uiObjectTagFactories.clear();
    }

    public String getModuleAlias() {
        return this.moduleAlias;
    }

    public GwtModuleRunner getModuleRunner() {
        return this.gwtModuleRunner;
    }

    public String getTestedModuleName() {
        return this.testedModuleName;
    }

    public List<UiObjectTagFactory<?>> getUiObjectTagFactories() {
        return this.uiObjectTagFactories;
    }

    public void setupGwtModule(Class<?> testClass) {
        GwtModule gwtModule = testClass.getAnnotation(GwtModule.class);
        if (gwtModule == null) {
            throw new GwtTestConfigurationException("The test class " + testClass.getName() + " must be annotated with @" + GwtModule.class.getSimpleName() + " to specify the fully qualified name of the GWT module to test");
        }
        String moduleName = gwtModule.value();
        if (moduleName == null || "".equals(moduleName.trim())) {
            throw new GwtTestConfigurationException("Incorrect value for @" + GwtModule.class.getSimpleName() + " on " + testClass.getName() + ": " + moduleName);
        }
        if (!GwtFactory.get().getConfigurationLoader().getGwtModules().contains(moduleName)) {
            throw new GwtTestConfigurationException("The tested @GwtModule '" + moduleName + "' configured in " + testClass.getName() + " has not been found. Did you forget to declare a 'gwt-module' property in your 'META-INF/gwt-test-utils.properties' configuration file ?");
        }
        this.testedModuleName = moduleName;
    }

    public void setupInstance(GwtModuleRunner gwtModuleRunner) {
        if (this.gwtModuleRunner != null) {
            throw new GwtTestException("Because of the single-threaded nature of the GWT environment, gwt-test-utils tests can not be run in multiple thread at the same time");
        }
        this.gwtModuleRunner = gwtModuleRunner;
        this.moduleAlias = ModuleData.get(this.testedModuleName).getAlias();
        this.setupDebugIdImpl(gwtModuleRunner.ensureDebugId());
    }

    private void setupDebugIdImpl(boolean ensureDebugId) {
        UIObject.DebugIdImpl debugIdImplToUse = ensureDebugId ? this.enabledInstance : this.disabledInstance;
        GwtReflectionUtils.setStaticField(UIObject.class, "debugIdImpl", debugIdImplToUse);
    }
}

