/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal;

import com.google.gwt.dev.javac.CompilationState;
import com.google.gwt.dev.javac.CompiledClass;
import com.google.gwt.dev.util.Name;
import com.googlecode.gwt.test.exceptions.GwtTestException;
import com.googlecode.gwt.test.exceptions.GwtTestPatchException;
import com.googlecode.gwt.test.internal.ConfigurationLoader;
import com.googlecode.gwt.test.internal.GwtClassPool;
import com.googlecode.gwt.test.internal.GwtTranslator;
import com.googlecode.gwt.test.internal.rewrite.OverlayTypesRewriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.ProtectionDomain;
import java.util.regex.Pattern;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.Loader;
import javassist.NotFoundException;
import javassist.Translator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GwtClassLoader
extends Loader {
    private final CompilationState compilationState;
    private final Pattern delegatePattern;
    private ProtectionDomain domain;
    private final ClassPool source;
    private final Translator translator;

    static GwtClassLoader createClassLoader(ConfigurationLoader configurationLoader, CompilationState compilationState, OverlayTypesRewriter overlayRewriter) {
        try {
            if (overlayRewriter == null) {
                return new GwtClassLoader(configurationLoader, compilationState);
            }
            return new GwtClassLoaderWithRewriter(configurationLoader, compilationState, overlayRewriter);
        }
        catch (Exception e) {
            throw new GwtTestException("Error during " + GwtClassLoader.class.getSimpleName() + " instanciation :", e);
        }
    }

    private GwtClassLoader(ConfigurationLoader configurationLoader, CompilationState compilationState) throws NotFoundException, CannotCompileException {
        super(GwtClassPool.get());
        this.compilationState = compilationState;
        this.source = GwtClassPool.get();
        this.translator = new GwtTranslator(configurationLoader);
        StringBuilder sb = new StringBuilder("^(");
        sb = this.appendPackageToDelegate(sb, "java.");
        sb = this.appendPackageToDelegate(sb, "javax.");
        sb = this.appendPackageToDelegate(sb, "sun.");
        sb = this.appendPackageToDelegate(sb, "com.sun.");
        sb = this.appendPackageToDelegate(sb, "org.w3c.");
        sb = this.appendPackageToDelegate(sb, "org.xml.");
        for (String s : configurationLoader.getDelegates()) {
            if (s.endsWith(".")) {
                sb = this.appendPackageToDelegate(sb, s);
                continue;
            }
            sb = this.appendClassToDelegate(sb, s);
        }
        sb.replace(sb.length() - 1, sb.length(), "");
        sb.append(")$");
        this.delegatePattern = Pattern.compile(sb.toString());
    }

    public void setDomain(ProtectionDomain domain) {
        super.setDomain(domain);
        this.domain = domain;
    }

    protected Class<?> findClass(String className) throws ClassNotFoundException {
        String pname;
        byte[] classfile = this.findClassBytes(className);
        int i = className.lastIndexOf(46);
        if (i != -1 && this.getPackage(pname = className.substring(0, i)) == null) {
            try {
                this.definePackage(pname, null, null, null, null, null, null, null);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        try {
            if (this.domain == null) {
                return this.defineClass(className, classfile, 0, classfile.length);
            }
            return this.defineClass(className, classfile, 0, classfile.length, this.domain);
        }
        catch (Throwable t) {
            throw new GwtTestPatchException("Error while defining " + className + " from modified bytecode", t);
        }
    }

    protected byte[] findClassBytes(String className) throws ClassNotFoundException {
        try {
            this.translator.onLoad(this.source, className);
            try {
                return this.source.get(className).toBytecode();
            }
            catch (NotFoundException e) {
                return null;
            }
        }
        catch (NotFoundException e) {
            String internalName = Name.BinaryName.toInternalName((String)className);
            CompiledClass compiledClass = (CompiledClass)this.compilationState.getClassFileMap().get(internalName);
            if (compiledClass != null) {
                this.addCompiledClass(compiledClass);
                try {
                    return this.applyPatchers(className);
                }
                catch (Exception e2) {
                    throw new ClassNotFoundException("caught an exception while otaining a class file for generated class " + className, e2);
                }
            }
            throw new ClassNotFoundException(className);
        }
        catch (GwtTestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClassNotFoundException("caught an exception while obtaining a class file for " + className, e);
        }
    }

    protected Class<?> loadClassByDelegation(String name) throws ClassNotFoundException {
        return this.delegatePattern.matcher(name).matches() ? this.delegateToParent(name) : null;
    }

    private void addCompiledClass(CompiledClass compiledClass) {
        ByteArrayInputStream is = new ByteArrayInputStream(compiledClass.getBytes());
        try {
            this.source.makeClass((InputStream)is);
        }
        catch (Exception e) {
            throw new GwtTestPatchException("Error while handling generated class '" + compiledClass.getInternalName(), e);
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException e) {}
        }
    }

    private StringBuilder appendClassToDelegate(StringBuilder sb, String className) {
        return sb.append(className.replaceAll("\\.", "\\\\\\.").replaceAll("\\$", "\\\\\\$")).append("|");
    }

    private StringBuilder appendPackageToDelegate(StringBuilder sb, String packageName) {
        return sb.append(packageName.replaceAll("\\.", "\\\\\\.")).append(".+|");
    }

    private byte[] applyPatchers(String className) throws NotFoundException, CannotCompileException, IOException {
        this.translator.onLoad(this.source, className);
        try {
            return this.source.get(className).toBytecode();
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    private static class GwtClassLoaderWithRewriter
    extends GwtClassLoader {
        private static final CtClass JSO_CTCLASS = GwtClassPool.getClass("com.google.gwt.core.client.JavaScriptObject");
        private final OverlayTypesRewriter overlayRewriter;

        private GwtClassLoaderWithRewriter(ConfigurationLoader configurationLoader, CompilationState compilationState, OverlayTypesRewriter overlayRewriter) throws NotFoundException, CannotCompileException {
            super(configurationLoader, compilationState);
            this.overlayRewriter = overlayRewriter;
        }

        protected byte[] findClassBytes(String className) throws ClassNotFoundException {
            if (this.overlayRewriter.isJsoIntf(className)) {
                return this.overlayRewriter.writeJsoIntf(className);
            }
            if (this.isUnsupportedOverlayType(className)) {
                throw new GwtTestPatchException("Overlay type '" + className + "' has not been found. Did you forget to inherit some GWT module ? Does your GWT code compile using the -strict option ?");
            }
            String classFromPool = this.overlayRewriter.isJsoImpl(className) ? className.substring(0, className.length() - 1) : className;
            byte[] classBytes = super.findClassBytes(classFromPool);
            classBytes = this.overlayRewriter.rewrite(className, classBytes);
            return classBytes;
        }

        private boolean isUnsupportedOverlayType(String className) {
            CtClass classToLoad = null;
            try {
                classToLoad = GwtClassPool.getClass(className);
            }
            catch (GwtTestPatchException gwtTestPatchException) {
                // empty catch block
            }
            return classToLoad != null && classToLoad.subclassOf(JSO_CTCLASS) && classToLoad != JSO_CTCLASS;
        }
    }
}

