/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.assertions;

import com.googlecode.gwt.test.finder.GwtFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GwtInstance {
    private final String[] identifier;
    private final Object instance;

    static void validateNotNull(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("Expected type cannot be null");
        }
    }

    protected GwtInstance(String ... identifier) {
        this.identifier = identifier;
        this.instance = GwtFinder.object(identifier);
    }

    public <T> T ofType(Class<T> type) throws NullPointerException, ClassCastException {
        GwtInstance.validateNotNull(type);
        if (this.instance == null) {
            throw new NullPointerException("Object with identifier '" + this.identifierToString() + "' is null");
        }
        return (T)this.instance;
    }

    final Object getInstance() {
        return this.instance;
    }

    private String identifierToString() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.identifier) {
            sb.append("'").append(s).append("', ");
        }
        return sb.substring(0, sb.length() - 2);
    }
}

